// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Auto Scaling group recommendation.
 */
class AutoScalingGroupRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the Auto Scaling group.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    val autoScalingGroupArn: kotlin.String? = builder.autoScalingGroupArn
    /**
     * The name of the Auto Scaling group.
     */
    val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * An array of objects that describe the current configuration of the Auto Scaling
     * group.
     */
    val currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration? = builder.currentConfiguration
    /**
     * The finding classification of the Auto Scaling group.
     * Findings for Auto Scaling groups include:
     * NotOptimized
     * —An Auto Scaling group is considered not optimized when Compute Optimizer identifies a
     * recommendation that can provide better performance for your workload.
     * Optimized
     * —An Auto Scaling
     * group is considered optimized when Compute Optimizer determines that the group
     * is correctly provisioned to run your workload based on the chosen instance type.
     * For optimized resources, Compute Optimizer might recommend a new generation
     * instance type.
     */
    val finding: aws.sdk.kotlin.services.computeoptimizer.model.Finding? = builder.finding
    /**
     * The timestamp  of when the Auto Scaling group recommendation was last
     * refreshed.
     */
    val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days for which utilization metrics were analyzed for the Auto Scaling group.
     */
    val lookBackPeriodInDays: kotlin.Double = builder.lookBackPeriodInDays
    /**
     * An array of objects that describe the recommendation options for the Auto Scaling
     * group.
     */
    val recommendationOptions: List<AutoScalingGroupRecommendationOption>? = builder.recommendationOptions
    /**
     * An array of objects that describe the utilization metrics of the Auto Scaling
     * group.
     */
    val utilizationMetrics: List<UtilizationMetric>? = builder.utilizationMetrics

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroupRecommendation(")
        append("accountId=$accountId,")
        append("autoScalingGroupArn=$autoScalingGroupArn,")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("currentConfiguration=$currentConfiguration,")
        append("finding=$finding,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookBackPeriodInDays=$lookBackPeriodInDays,")
        append("recommendationOptions=$recommendationOptions,")
        append("utilizationMetrics=$utilizationMetrics)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (autoScalingGroupArn?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroupName?.hashCode() ?: 0)
        result = 31 * result + (currentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriodInDays.hashCode())
        result = 31 * result + (recommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AutoScalingGroupRecommendation

        if (accountId != other.accountId) return false
        if (autoScalingGroupArn != other.autoScalingGroupArn) return false
        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (currentConfiguration != other.currentConfiguration) return false
        if (finding != other.finding) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (lookBackPeriodInDays != other.lookBackPeriodInDays) return false
        if (recommendationOptions != other.recommendationOptions) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account ID of the Auto Scaling group.
         */
        var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Auto Scaling group.
         */
        var autoScalingGroupArn: kotlin.String? = null
        /**
         * The name of the Auto Scaling group.
         */
        var autoScalingGroupName: kotlin.String? = null
        /**
         * An array of objects that describe the current configuration of the Auto Scaling
         * group.
         */
        var currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration? = null
        /**
         * The finding classification of the Auto Scaling group.
         * Findings for Auto Scaling groups include:
         * NotOptimized
         * —An Auto Scaling group is considered not optimized when Compute Optimizer identifies a
         * recommendation that can provide better performance for your workload.
         * Optimized
         * —An Auto Scaling
         * group is considered optimized when Compute Optimizer determines that the group
         * is correctly provisioned to run your workload based on the chosen instance type.
         * For optimized resources, Compute Optimizer might recommend a new generation
         * instance type.
         */
        var finding: aws.sdk.kotlin.services.computeoptimizer.model.Finding? = null
        /**
         * The timestamp  of when the Auto Scaling group recommendation was last
         * refreshed.
         */
        var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days for which utilization metrics were analyzed for the Auto Scaling group.
         */
        var lookBackPeriodInDays: kotlin.Double = 0.0
        /**
         * An array of objects that describe the recommendation options for the Auto Scaling
         * group.
         */
        var recommendationOptions: List<AutoScalingGroupRecommendationOption>? = null
        /**
         * An array of objects that describe the utilization metrics of the Auto Scaling
         * group.
         */
        var utilizationMetrics: List<UtilizationMetric>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation) : this() {
            this.accountId = x.accountId
            this.autoScalingGroupArn = x.autoScalingGroupArn
            this.autoScalingGroupName = x.autoScalingGroupName
            this.currentConfiguration = x.currentConfiguration
            this.finding = x.finding
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookBackPeriodInDays = x.lookBackPeriodInDays
            this.recommendationOptions = x.recommendationOptions
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation = AutoScalingGroupRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration] inside the given [block]
         */
        fun currentConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.currentConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration.invoke(block)
        }
    }
}
