// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.computeoptimizer.model.*
import aws.sdk.kotlin.services.computeoptimizer.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Compute Optimizer"
const val ServiceApiVersion: String = "2019-11-01"
const val SdkVersion: String = "0.9.4-beta"

internal class DefaultComputeOptimizerClient(override val config: ComputeOptimizerClient.Config) : ComputeOptimizerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Describes recommendation export jobs created in the last seven days.
     * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your
     * recommendations. Then use the DescribeRecommendationExportJobs action
     * to view your export jobs.
     */
    override suspend fun describeRecommendationExportJobs(input: DescribeRecommendationExportJobsRequest): DescribeRecommendationExportJobsResponse {
        val op = SdkHttpOperation.build<DescribeRecommendationExportJobsRequest, DescribeRecommendationExportJobsResponse> {
            serializer = DescribeRecommendationExportJobsOperationSerializer()
            deserializer = DescribeRecommendationExportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRecommendationExportJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Exports optimization recommendations for Auto Scaling groups.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportAutoScalingGroupRecommendations(input: ExportAutoScalingGroupRecommendationsRequest): ExportAutoScalingGroupRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportAutoScalingGroupRecommendationsRequest, ExportAutoScalingGroupRecommendationsResponse> {
            serializer = ExportAutoScalingGroupRecommendationsOperationSerializer()
            deserializer = ExportAutoScalingGroupRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportAutoScalingGroupRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Exports optimization recommendations for Amazon EBS volumes.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportEbsVolumeRecommendations(input: ExportEbsVolumeRecommendationsRequest): ExportEbsVolumeRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportEbsVolumeRecommendationsRequest, ExportEbsVolumeRecommendationsResponse> {
            serializer = ExportEBSVolumeRecommendationsOperationSerializer()
            deserializer = ExportEBSVolumeRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportEBSVolumeRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Exports optimization recommendations for Amazon EC2 instances.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportEc2InstanceRecommendations(input: ExportEc2InstanceRecommendationsRequest): ExportEc2InstanceRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportEc2InstanceRecommendationsRequest, ExportEc2InstanceRecommendationsResponse> {
            serializer = ExportEC2InstanceRecommendationsOperationSerializer()
            deserializer = ExportEC2InstanceRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportEC2InstanceRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Exports optimization recommendations for Lambda functions.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportLambdaFunctionRecommendations(input: ExportLambdaFunctionRecommendationsRequest): ExportLambdaFunctionRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportLambdaFunctionRecommendationsRequest, ExportLambdaFunctionRecommendationsResponse> {
            serializer = ExportLambdaFunctionRecommendationsOperationSerializer()
            deserializer = ExportLambdaFunctionRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportLambdaFunctionRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns Auto Scaling group recommendations.
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that
     * meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported
     * resources and requirements in the Compute Optimizer User
     * Guide.
     */
    override suspend fun getAutoScalingGroupRecommendations(input: GetAutoScalingGroupRecommendationsRequest): GetAutoScalingGroupRecommendationsResponse {
        val op = SdkHttpOperation.build<GetAutoScalingGroupRecommendationsRequest, GetAutoScalingGroupRecommendationsResponse> {
            serializer = GetAutoScalingGroupRecommendationsOperationSerializer()
            deserializer = GetAutoScalingGroupRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAutoScalingGroupRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     * Compute Optimizer generates recommendations for Amazon EBS volumes that
     * meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported
     * resources and requirements in the Compute Optimizer User
     * Guide.
     */
    override suspend fun getEbsVolumeRecommendations(input: GetEbsVolumeRecommendationsRequest): GetEbsVolumeRecommendationsResponse {
        val op = SdkHttpOperation.build<GetEbsVolumeRecommendationsRequest, GetEbsVolumeRecommendationsResponse> {
            serializer = GetEBSVolumeRecommendationsOperationSerializer()
            deserializer = GetEBSVolumeRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEBSVolumeRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns Amazon EC2 instance recommendations.
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more
     * information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements in the Compute Optimizer User
     * Guide.
     */
    override suspend fun getEc2InstanceRecommendations(input: GetEc2InstanceRecommendationsRequest): GetEc2InstanceRecommendationsResponse {
        val op = SdkHttpOperation.build<GetEc2InstanceRecommendationsRequest, GetEc2InstanceRecommendationsResponse> {
            serializer = GetEC2InstanceRecommendationsOperationSerializer()
            deserializer = GetEC2InstanceRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEC2InstanceRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the projected utilization metrics of Amazon EC2 instance
     * recommendations.
     * The Cpu and Memory metrics are the only projected
     * utilization metrics returned when you run this action. Additionally, the
     * Memory metric is returned only for resources that have the unified
     * CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent.
     */
    override suspend fun getEc2RecommendationProjectedMetrics(input: GetEc2RecommendationProjectedMetricsRequest): GetEc2RecommendationProjectedMetricsResponse {
        val op = SdkHttpOperation.build<GetEc2RecommendationProjectedMetricsRequest, GetEc2RecommendationProjectedMetricsResponse> {
            serializer = GetEC2RecommendationProjectedMetricsOperationSerializer()
            deserializer = GetEC2RecommendationProjectedMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEC2RecommendationProjectedMetrics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer
     * service.
     * If the account is the management account of an organization, this action also confirms
     * the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information
     * about the enrollment status of member accounts of an organization.
     */
    override suspend fun getEnrollmentStatus(input: GetEnrollmentStatusRequest): GetEnrollmentStatusResponse {
        val op = SdkHttpOperation.build<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> {
            serializer = GetEnrollmentStatusOperationSerializer()
            deserializer = GetEnrollmentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEnrollmentStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member
     * accounts, if your account is an organization management account.
     * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
     */
    override suspend fun getEnrollmentStatusesForOrganization(input: GetEnrollmentStatusesForOrganizationRequest): GetEnrollmentStatusesForOrganizationResponse {
        val op = SdkHttpOperation.build<GetEnrollmentStatusesForOrganizationRequest, GetEnrollmentStatusesForOrganizationResponse> {
            serializer = GetEnrollmentStatusesForOrganizationOperationSerializer()
            deserializer = GetEnrollmentStatusesForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEnrollmentStatusesForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns Lambda function recommendations.
     * Compute Optimizer generates recommendations for functions that meet a specific set
     * of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements in the Compute Optimizer User
     * Guide.
     */
    override suspend fun getLambdaFunctionRecommendations(input: GetLambdaFunctionRecommendationsRequest): GetLambdaFunctionRecommendationsResponse {
        val op = SdkHttpOperation.build<GetLambdaFunctionRecommendationsRequest, GetLambdaFunctionRecommendationsResponse> {
            serializer = GetLambdaFunctionRecommendationsOperationSerializer()
            deserializer = GetLambdaFunctionRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLambdaFunctionRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the optimization findings for an account.
     * It returns the number of:
     * Amazon EC2 instances in an account that are
     * Underprovisioned, Overprovisioned, or
     * Optimized.
     * Auto Scaling groups in an account that are NotOptimized, or
     * Optimized.
     * Amazon EBS volumes in an account that are NotOptimized,
     * or Optimized.
     * Lambda functions in an account that are NotOptimized,
     * or Optimized.
     */
    override suspend fun getRecommendationSummaries(input: GetRecommendationSummariesRequest): GetRecommendationSummariesResponse {
        val op = SdkHttpOperation.build<GetRecommendationSummariesRequest, GetRecommendationSummariesResponse> {
            serializer = GetRecommendationSummariesOperationSerializer()
            deserializer = GetRecommendationSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecommendationSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     * If the account is a management account of an organization, this action can also be
     * used to enroll member accounts of the organization.
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its
     * recommendations, and to opt out. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon Web Services Identity and Access Management in the Compute Optimizer User Guide.
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your
     * account to access its data. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using
     * Service-Linked Roles for Compute Optimizer in the Compute Optimizer User Guide.
     */
    override suspend fun updateEnrollmentStatus(input: UpdateEnrollmentStatusRequest): UpdateEnrollmentStatusResponse {
        val op = SdkHttpOperation.build<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResponse> {
            serializer = UpdateEnrollmentStatusOperationSerializer()
            deserializer = UpdateEnrollmentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEnrollmentStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "ComputeOptimizerService"
            version = "1.0"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "compute-optimizer"
        }
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
