// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.computeoptimizer.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.computeoptimizer.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Compute Optimizer is a service that analyzes the configuration and utilization
 * metrics of your Amazon Web Services compute resources, such as Amazon EC2
 * instances, Amazon EC2 Auto Scaling groups, Lambda functions, and Amazon EBS volumes. It reports whether your resources are optimal, and generates
 * optimization recommendations to reduce the cost and improve the performance of your
 * workloads. Compute Optimizer also provides recent utilization metric data, in addition
 * to projected utilization metric data for the recommendations, which you can use to
 * evaluate which recommendation provides the best price-performance trade-off. The
 * analysis of your usage patterns can help you decide when to move or resize your running
 * resources, and still meet your performance and capacity requirements. For more
 * information about Compute Optimizer, including the required permissions to use the
 * service, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/">Compute Optimizer User Guide.
 */
interface ComputeOptimizerClient : SdkClient {

    override val serviceName: String
        get() = "Compute Optimizer"
    /**
     * ComputeOptimizerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): ComputeOptimizerClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultComputeOptimizerClient(config)
        }

        operator fun invoke(config: Config): ComputeOptimizerClient = DefaultComputeOptimizerClient(config)

        /**
         * Construct a [ComputeOptimizerClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): ComputeOptimizerClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return ComputeOptimizerClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Describes recommendation export jobs created in the last seven days.
     * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your
     * recommendations. Then use the DescribeRecommendationExportJobs action
     * to view your export jobs.
     */
    suspend fun describeRecommendationExportJobs(input: DescribeRecommendationExportJobsRequest): DescribeRecommendationExportJobsResponse

    /**
     * Describes recommendation export jobs created in the last seven days.
     * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your
     * recommendations. Then use the DescribeRecommendationExportJobs action
     * to view your export jobs.
     */
    suspend fun describeRecommendationExportJobs(block: DescribeRecommendationExportJobsRequest.Builder.() -> Unit) = describeRecommendationExportJobs(DescribeRecommendationExportJobsRequest.Builder().apply(block).build())

    /**
     * Exports optimization recommendations for Auto Scaling groups.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     */
    suspend fun exportAutoScalingGroupRecommendations(input: ExportAutoScalingGroupRecommendationsRequest): ExportAutoScalingGroupRecommendationsResponse

    /**
     * Exports optimization recommendations for Auto Scaling groups.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     */
    suspend fun exportAutoScalingGroupRecommendations(block: ExportAutoScalingGroupRecommendationsRequest.Builder.() -> Unit) = exportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest.Builder().apply(block).build())

    /**
     * Exports optimization recommendations for Amazon EBS volumes.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     */
    suspend fun exportEbsVolumeRecommendations(input: ExportEbsVolumeRecommendationsRequest): ExportEbsVolumeRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon EBS volumes.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     */
    suspend fun exportEbsVolumeRecommendations(block: ExportEbsVolumeRecommendationsRequest.Builder.() -> Unit) = exportEbsVolumeRecommendations(ExportEbsVolumeRecommendationsRequest.Builder().apply(block).build())

    /**
     * Exports optimization recommendations for Amazon EC2 instances.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     */
    suspend fun exportEc2InstanceRecommendations(input: ExportEc2InstanceRecommendationsRequest): ExportEc2InstanceRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon EC2 instances.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     */
    suspend fun exportEc2InstanceRecommendations(block: ExportEc2InstanceRecommendationsRequest.Builder.() -> Unit) = exportEc2InstanceRecommendations(ExportEc2InstanceRecommendationsRequest.Builder().apply(block).build())

    /**
     * Exports optimization recommendations for Lambda functions.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     */
    suspend fun exportLambdaFunctionRecommendations(input: ExportLambdaFunctionRecommendationsRequest): ExportLambdaFunctionRecommendationsResponse

    /**
     * Exports optimization recommendations for Lambda functions.
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata
     * in a JavaScript Object Notation (JSON)   (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see
     * <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations in the Compute Optimizer User
     * Guide.
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     */
    suspend fun exportLambdaFunctionRecommendations(block: ExportLambdaFunctionRecommendationsRequest.Builder.() -> Unit) = exportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest.Builder().apply(block).build())

    /**
     * Returns Auto Scaling group recommendations.
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that
     * meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported
     * resources and requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getAutoScalingGroupRecommendations(input: GetAutoScalingGroupRecommendationsRequest): GetAutoScalingGroupRecommendationsResponse

    /**
     * Returns Auto Scaling group recommendations.
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that
     * meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported
     * resources and requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getAutoScalingGroupRecommendations(block: GetAutoScalingGroupRecommendationsRequest.Builder.() -> Unit) = getAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest.Builder().apply(block).build())

    /**
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     * Compute Optimizer generates recommendations for Amazon EBS volumes that
     * meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported
     * resources and requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getEbsVolumeRecommendations(input: GetEbsVolumeRecommendationsRequest): GetEbsVolumeRecommendationsResponse

    /**
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     * Compute Optimizer generates recommendations for Amazon EBS volumes that
     * meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported
     * resources and requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getEbsVolumeRecommendations(block: GetEbsVolumeRecommendationsRequest.Builder.() -> Unit) = getEbsVolumeRecommendations(GetEbsVolumeRecommendationsRequest.Builder().apply(block).build())

    /**
     * Returns Amazon EC2 instance recommendations.
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more
     * information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getEc2InstanceRecommendations(input: GetEc2InstanceRecommendationsRequest): GetEc2InstanceRecommendationsResponse

    /**
     * Returns Amazon EC2 instance recommendations.
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more
     * information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getEc2InstanceRecommendations(block: GetEc2InstanceRecommendationsRequest.Builder.() -> Unit) = getEc2InstanceRecommendations(GetEc2InstanceRecommendationsRequest.Builder().apply(block).build())

    /**
     * Returns the projected utilization metrics of Amazon EC2 instance
     * recommendations.
     * The Cpu and Memory metrics are the only projected
     * utilization metrics returned when you run this action. Additionally, the
     * Memory metric is returned only for resources that have the unified
     * CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent.
     */
    suspend fun getEc2RecommendationProjectedMetrics(input: GetEc2RecommendationProjectedMetricsRequest): GetEc2RecommendationProjectedMetricsResponse

    /**
     * Returns the projected utilization metrics of Amazon EC2 instance
     * recommendations.
     * The Cpu and Memory metrics are the only projected
     * utilization metrics returned when you run this action. Additionally, the
     * Memory metric is returned only for resources that have the unified
     * CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent.
     */
    suspend fun getEc2RecommendationProjectedMetrics(block: GetEc2RecommendationProjectedMetricsRequest.Builder.() -> Unit) = getEc2RecommendationProjectedMetrics(GetEc2RecommendationProjectedMetricsRequest.Builder().apply(block).build())

    /**
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer
     * service.
     * If the account is the management account of an organization, this action also confirms
     * the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information
     * about the enrollment status of member accounts of an organization.
     */
    suspend fun getEnrollmentStatus(input: GetEnrollmentStatusRequest): GetEnrollmentStatusResponse

    /**
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer
     * service.
     * If the account is the management account of an organization, this action also confirms
     * the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information
     * about the enrollment status of member accounts of an organization.
     */
    suspend fun getEnrollmentStatus(block: GetEnrollmentStatusRequest.Builder.() -> Unit) = getEnrollmentStatus(GetEnrollmentStatusRequest.Builder().apply(block).build())

    /**
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member
     * accounts, if your account is an organization management account.
     * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
     */
    suspend fun getEnrollmentStatusesForOrganization(input: GetEnrollmentStatusesForOrganizationRequest): GetEnrollmentStatusesForOrganizationResponse

    /**
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member
     * accounts, if your account is an organization management account.
     * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
     */
    suspend fun getEnrollmentStatusesForOrganization(block: GetEnrollmentStatusesForOrganizationRequest.Builder.() -> Unit) = getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationRequest.Builder().apply(block).build())

    /**
     * Returns Lambda function recommendations.
     * Compute Optimizer generates recommendations for functions that meet a specific set
     * of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getLambdaFunctionRecommendations(input: GetLambdaFunctionRecommendationsRequest): GetLambdaFunctionRecommendationsResponse

    /**
     * Returns Lambda function recommendations.
     * Compute Optimizer generates recommendations for functions that meet a specific set
     * of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements in the Compute Optimizer User
     * Guide.
     */
    suspend fun getLambdaFunctionRecommendations(block: GetLambdaFunctionRecommendationsRequest.Builder.() -> Unit) = getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest.Builder().apply(block).build())

    /**
     * Returns the optimization findings for an account.
     * It returns the number of:
     * Amazon EC2 instances in an account that are
     * Underprovisioned, Overprovisioned, or
     * Optimized.
     * Auto Scaling groups in an account that are NotOptimized, or
     * Optimized.
     * Amazon EBS volumes in an account that are NotOptimized,
     * or Optimized.
     * Lambda functions in an account that are NotOptimized,
     * or Optimized.
     */
    suspend fun getRecommendationSummaries(input: GetRecommendationSummariesRequest): GetRecommendationSummariesResponse

    /**
     * Returns the optimization findings for an account.
     * It returns the number of:
     * Amazon EC2 instances in an account that are
     * Underprovisioned, Overprovisioned, or
     * Optimized.
     * Auto Scaling groups in an account that are NotOptimized, or
     * Optimized.
     * Amazon EBS volumes in an account that are NotOptimized,
     * or Optimized.
     * Lambda functions in an account that are NotOptimized,
     * or Optimized.
     */
    suspend fun getRecommendationSummaries(block: GetRecommendationSummariesRequest.Builder.() -> Unit) = getRecommendationSummaries(GetRecommendationSummariesRequest.Builder().apply(block).build())

    /**
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     * If the account is a management account of an organization, this action can also be
     * used to enroll member accounts of the organization.
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its
     * recommendations, and to opt out. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon Web Services Identity and Access Management in the Compute Optimizer User Guide.
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your
     * account to access its data. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using
     * Service-Linked Roles for Compute Optimizer in the Compute Optimizer User Guide.
     */
    suspend fun updateEnrollmentStatus(input: UpdateEnrollmentStatusRequest): UpdateEnrollmentStatusResponse

    /**
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     * If the account is a management account of an organization, this action can also be
     * used to enroll member accounts of the organization.
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its
     * recommendations, and to opt out. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon Web Services Identity and Access Management in the Compute Optimizer User Guide.
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your
     * account to access its data. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using
     * Service-Linked Roles for Compute Optimizer in the Compute Optimizer User Guide.
     */
    suspend fun updateEnrollmentStatus(block: UpdateEnrollmentStatusRequest.Builder.() -> Unit) = updateEnrollmentStatus(UpdateEnrollmentStatusRequest.Builder().apply(block).build())
}
