// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.transform

import aws.sdk.kotlin.services.computeoptimizer.model.ComputeOptimizerException
import aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationError
import aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetEBSVolumeRecommendationsOperationDeserializer: HttpDeserialize<GetEbsVolumeRecommendationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEbsVolumeRecommendationsResponse {
        if (!response.status.isSuccess()) {
            throwGetEbsVolumeRecommendationsError(context, response)
        }
        val builder = GetEbsVolumeRecommendationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEBSVolumeRecommendationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEbsVolumeRecommendationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComputeOptimizerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingAuthenticationToken" -> MissingAuthenticationTokenDeserializer().deserialize(context, wrappedResponse)
        "OptInRequiredException" -> OptInRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComputeOptimizerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEBSVolumeRecommendationsOperationBody(builder: GetEbsVolumeRecommendationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val VOLUMERECOMMENDATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("volumeRecommendations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(VOLUMERECOMMENDATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<GetRecommendationError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGetRecommendationErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                VOLUMERECOMMENDATIONS_DESCRIPTOR.index -> builder.volumeRecommendations =
                    deserializer.deserializeList(VOLUMERECOMMENDATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<VolumeRecommendation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVolumeRecommendationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
