// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.paginators

import aws.sdk.kotlin.services.computeoptimizer.ComputeOptimizerClient
import aws.sdk.kotlin.services.computeoptimizer.model.AccountEnrollmentStatus
import aws.sdk.kotlin.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation
import aws.sdk.kotlin.services.computeoptimizer.model.RecommendationExportJob
import aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferencesDetail
import aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeRecommendationExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeRecommendationExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRecommendationExportJobsResponse]
 */
public fun ComputeOptimizerClient.describeRecommendationExportJobsPaginated(initialRequest: DescribeRecommendationExportJobsRequest): Flow<DescribeRecommendationExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeRecommendationExportJobsPaginated.describeRecommendationExportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeRecommendationExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRecommendationExportJobsResponse]
 */
public fun ComputeOptimizerClient.describeRecommendationExportJobsPaginated(block: DescribeRecommendationExportJobsRequest.Builder.() -> Unit): Flow<DescribeRecommendationExportJobsResponse> =
    describeRecommendationExportJobsPaginated(DescribeRecommendationExportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeRecommendationExportJobsPaginated]
 * to access the nested member [RecommendationExportJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecommendationExportJob]
 */
@JvmName("describeRecommendationExportJobsResponseRecommendationExportJob")
public fun Flow<DescribeRecommendationExportJobsResponse>.recommendationExportJobs(): Flow<RecommendationExportJob> =
    transform() { response ->
        response.recommendationExportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetEnrollmentStatusesForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetEnrollmentStatusesForOrganizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEnrollmentStatusesForOrganizationResponse]
 */
public fun ComputeOptimizerClient.getEnrollmentStatusesForOrganizationPaginated(initialRequest: GetEnrollmentStatusesForOrganizationRequest): Flow<GetEnrollmentStatusesForOrganizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getEnrollmentStatusesForOrganizationPaginated.getEnrollmentStatusesForOrganization(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetEnrollmentStatusesForOrganizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEnrollmentStatusesForOrganizationResponse]
 */
public fun ComputeOptimizerClient.getEnrollmentStatusesForOrganizationPaginated(block: GetEnrollmentStatusesForOrganizationRequest.Builder.() -> Unit): Flow<GetEnrollmentStatusesForOrganizationResponse> =
    getEnrollmentStatusesForOrganizationPaginated(GetEnrollmentStatusesForOrganizationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getEnrollmentStatusesForOrganizationPaginated]
 * to access the nested member [AccountEnrollmentStatus]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountEnrollmentStatus]
 */
@JvmName("getEnrollmentStatusesForOrganizationResponseAccountEnrollmentStatus")
public fun Flow<GetEnrollmentStatusesForOrganizationResponse>.accountEnrollmentStatuses(): Flow<AccountEnrollmentStatus> =
    transform() { response ->
        response.accountEnrollmentStatuses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetLambdaFunctionRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetLambdaFunctionRecommendationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLambdaFunctionRecommendationsResponse]
 */
public fun ComputeOptimizerClient.getLambdaFunctionRecommendationsPaginated(initialRequest: GetLambdaFunctionRecommendationsRequest): Flow<GetLambdaFunctionRecommendationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getLambdaFunctionRecommendationsPaginated.getLambdaFunctionRecommendations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetLambdaFunctionRecommendationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLambdaFunctionRecommendationsResponse]
 */
public fun ComputeOptimizerClient.getLambdaFunctionRecommendationsPaginated(block: GetLambdaFunctionRecommendationsRequest.Builder.() -> Unit): Flow<GetLambdaFunctionRecommendationsResponse> =
    getLambdaFunctionRecommendationsPaginated(GetLambdaFunctionRecommendationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getLambdaFunctionRecommendationsPaginated]
 * to access the nested member [LambdaFunctionRecommendation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LambdaFunctionRecommendation]
 */
@JvmName("getLambdaFunctionRecommendationsResponseLambdaFunctionRecommendation")
public fun Flow<GetLambdaFunctionRecommendationsResponse>.lambdaFunctionRecommendations(): Flow<LambdaFunctionRecommendation> =
    transform() { response ->
        response.lambdaFunctionRecommendations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetRecommendationPreferencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetRecommendationPreferencesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRecommendationPreferencesResponse]
 */
public fun ComputeOptimizerClient.getRecommendationPreferencesPaginated(initialRequest: GetRecommendationPreferencesRequest): Flow<GetRecommendationPreferencesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getRecommendationPreferencesPaginated.getRecommendationPreferences(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetRecommendationPreferencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRecommendationPreferencesResponse]
 */
public fun ComputeOptimizerClient.getRecommendationPreferencesPaginated(block: GetRecommendationPreferencesRequest.Builder.() -> Unit): Flow<GetRecommendationPreferencesResponse> =
    getRecommendationPreferencesPaginated(GetRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getRecommendationPreferencesPaginated]
 * to access the nested member [RecommendationPreferencesDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecommendationPreferencesDetail]
 */
@JvmName("getRecommendationPreferencesResponseRecommendationPreferencesDetail")
public fun Flow<GetRecommendationPreferencesResponse>.recommendationPreferencesDetails(): Flow<RecommendationPreferencesDetail> =
    transform() { response ->
        response.recommendationPreferencesDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetRecommendationSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetRecommendationSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRecommendationSummariesResponse]
 */
public fun ComputeOptimizerClient.getRecommendationSummariesPaginated(initialRequest: GetRecommendationSummariesRequest): Flow<GetRecommendationSummariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getRecommendationSummariesPaginated.getRecommendationSummaries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetRecommendationSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRecommendationSummariesResponse]
 */
public fun ComputeOptimizerClient.getRecommendationSummariesPaginated(block: GetRecommendationSummariesRequest.Builder.() -> Unit): Flow<GetRecommendationSummariesResponse> =
    getRecommendationSummariesPaginated(GetRecommendationSummariesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getRecommendationSummariesPaginated]
 * to access the nested member [RecommendationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecommendationSummary]
 */
@JvmName("getRecommendationSummariesResponseRecommendationSummary")
public fun Flow<GetRecommendationSummariesResponse>.recommendationSummaries(): Flow<RecommendationSummary> =
    transform() { response ->
        response.recommendationSummaries?.forEach {
            emit(it)
        }
    }
