// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the recommendation preferences to return in the response of a GetAutoScalingGroupRecommendations, GetEC2InstanceRecommendations, and GetEC2RecommendationProjectedMetrics request.
 */
public class RecommendationPreferences private constructor(builder: Builder) {
    /**
     * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
     *
     * For example, when you specify `AWS_ARM64` with:
     * + A GetEC2InstanceRecommendations or GetAutoScalingGroupRecommendations request, Compute Optimizer returns recommendations that consist of Graviton2 instance types only.
     * + A GetEC2RecommendationProjectedMetrics request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type recommendations only.
     * + A ExportEC2InstanceRecommendations or ExportAutoScalingGroupRecommendations request, Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
     */
    public val cpuVendorArchitectures: List<CpuVendorArchitecture>? = builder.cpuVendorArchitectures

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationPreferences(")
        append("cpuVendorArchitectures=$cpuVendorArchitectures")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpuVendorArchitectures?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationPreferences

        if (cpuVendorArchitectures != other.cpuVendorArchitectures) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.
         *
         * For example, when you specify `AWS_ARM64` with:
         * + A GetEC2InstanceRecommendations or GetAutoScalingGroupRecommendations request, Compute Optimizer returns recommendations that consist of Graviton2 instance types only.
         * + A GetEC2RecommendationProjectedMetrics request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type recommendations only.
         * + A ExportEC2InstanceRecommendations or ExportAutoScalingGroupRecommendations request, Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
         */
        public var cpuVendorArchitectures: List<CpuVendorArchitecture>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences) : this() {
            this.cpuVendorArchitectures = x.cpuVendorArchitectures
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences = RecommendationPreferences(this)
    }
}
