// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a recommendation export job.
 *
 * Use the DescribeRecommendationExportJobs action to view your recommendation export jobs.
 *
 * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations.
 */
public class RecommendationExportJob private constructor(builder: Builder) {
    /**
     * The timestamp of when the export job was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * An object that describes the destination of the export file.
     */
    public val destination: aws.sdk.kotlin.services.computeoptimizer.model.ExportDestination? = builder.destination
    /**
     * The reason for an export job failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The identification number of the export job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The timestamp of when the export job was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The resource type of the exported recommendations.
     */
    public val resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = builder.resourceType
    /**
     * The status of the export job.
     */
    public val status: aws.sdk.kotlin.services.computeoptimizer.model.JobStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationExportJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationExportJob(")
        append("creationTimestamp=$creationTimestamp,")
        append("destination=$destination,")
        append("failureReason=$failureReason,")
        append("jobId=$jobId,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("resourceType=$resourceType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationExportJob

        if (creationTimestamp != other.creationTimestamp) return false
        if (destination != other.destination) return false
        if (failureReason != other.failureReason) return false
        if (jobId != other.jobId) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationExportJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when the export job was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the destination of the export file.
         */
        public var destination: aws.sdk.kotlin.services.computeoptimizer.model.ExportDestination? = null
        /**
         * The reason for an export job failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The identification number of the export job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The timestamp of when the export job was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource type of the exported recommendations.
         */
        public var resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = null
        /**
         * The status of the export job.
         */
        public var status: aws.sdk.kotlin.services.computeoptimizer.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationExportJob) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.destination = x.destination
            this.failureReason = x.failureReason
            this.jobId = x.jobId
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.resourceType = x.resourceType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationExportJob = RecommendationExportJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.ExportDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.computeoptimizer.model.ExportDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.computeoptimizer.model.ExportDestination.invoke(block)
        }
    }
}
