// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetRecommendationPreferencesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of recommendation preferences to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of recommendation preferences.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The target resource type of the recommendation preference for which to return preferences.
     *
     * The `Ec2Instance` option encompasses standalone instances and instances that are part of Auto Scaling groups. The `AutoScalingGroup` option encompasses only instances that are part of an Auto Scaling group.
     *
     * The valid values for this parameter are `Ec2Instance` and `AutoScalingGroup`.
     */
    public val resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = builder.resourceType
    /**
     * An object that describes the scope of the recommendation preference to return.
     *
     * You can return recommendation preferences that are created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public val scope: aws.sdk.kotlin.services.computeoptimizer.model.Scope? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecommendationPreferencesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceType=$resourceType,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecommendationPreferencesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceType != other.resourceType) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of recommendation preferences to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of recommendation preferences.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The target resource type of the recommendation preference for which to return preferences.
         *
         * The `Ec2Instance` option encompasses standalone instances and instances that are part of Auto Scaling groups. The `AutoScalingGroup` option encompasses only instances that are part of an Auto Scaling group.
         *
         * The valid values for this parameter are `Ec2Instance` and `AutoScalingGroup`.
         */
        public var resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = null
        /**
         * An object that describes the scope of the recommendation preference to return.
         *
         * You can return recommendation preferences that are created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         */
        public var scope: aws.sdk.kotlin.services.computeoptimizer.model.Scope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceType = x.resourceType
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesRequest = GetRecommendationPreferencesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.Scope] inside the given [block]
         */
        public fun scope(block: aws.sdk.kotlin.services.computeoptimizer.model.Scope.Builder.() -> kotlin.Unit) {
            this.scope = aws.sdk.kotlin.services.computeoptimizer.model.Scope.invoke(block)
        }
    }
}
