// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the recommendation options for an Amazon ECS service.
 */
public class EcsServiceRecommendationOption private constructor(builder: Builder) {
    /**
     * The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
     */
    public val containerRecommendations: List<ContainerRecommendation>? = builder.containerRecommendations
    /**
     * The CPU size of the Amazon ECS service recommendation option.
     */
    public val cpu: kotlin.Int? = builder.cpu
    /**
     * The memory size of the Amazon ECS service recommendation option.
     */
    public val memory: kotlin.Int? = builder.memory
    /**
     * An array of objects that describe the projected utilization metrics of the Amazon ECS service recommendation option.
     */
    public val projectedUtilizationMetrics: List<EcsServiceProjectedUtilizationMetric>? = builder.projectedUtilizationMetrics
    /**
     * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
     *
     * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
     *
     * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsServiceRecommendationOption(")
        append("containerRecommendations=$containerRecommendations,")
        append("cpu=$cpu,")
        append("memory=$memory,")
        append("projectedUtilizationMetrics=$projectedUtilizationMetrics,")
        append("savingsOpportunity=$savingsOpportunity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerRecommendations?.hashCode() ?: 0
        result = 31 * result + (cpu ?: 0)
        result = 31 * result + (memory ?: 0)
        result = 31 * result + (projectedUtilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsServiceRecommendationOption

        if (containerRecommendations != other.containerRecommendations) return false
        if (cpu != other.cpu) return false
        if (memory != other.memory) return false
        if (projectedUtilizationMetrics != other.projectedUtilizationMetrics) return false
        if (savingsOpportunity != other.savingsOpportunity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
         */
        public var containerRecommendations: List<ContainerRecommendation>? = null
        /**
         * The CPU size of the Amazon ECS service recommendation option.
         */
        public var cpu: kotlin.Int? = null
        /**
         * The memory size of the Amazon ECS service recommendation option.
         */
        public var memory: kotlin.Int? = null
        /**
         * An array of objects that describe the projected utilization metrics of the Amazon ECS service recommendation option.
         */
        public var projectedUtilizationMetrics: List<EcsServiceProjectedUtilizationMetric>? = null
        /**
         * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
         *
         * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
         *
         * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationOption) : this() {
            this.containerRecommendations = x.containerRecommendations
            this.cpu = x.cpu
            this.memory = x.memory
            this.projectedUtilizationMetrics = x.projectedUtilizationMetrics
            this.savingsOpportunity = x.savingsOpportunity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationOption = EcsServiceRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }
    }
}
