// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a utilization metric of an Amazon Elastic Block Store (Amazon EBS) volume.
 *
 * Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.
 */
public class EbsUtilizationMetric private constructor(builder: Builder) {
    /**
     * The name of the utilization metric.
     *
     * The following utilization metrics are available:
     * + `VolumeReadOpsPerSecond` - The completed read operations per second from the volume in a specified period of time.Unit: Count
     * + `VolumeWriteOpsPerSecond` - The completed write operations per second to the volume in a specified period of time.Unit: Count
     * + `VolumeReadBytesPerSecond` - The bytes read per second from the volume in a specified period of time.Unit: Bytes
     * + `VolumeWriteBytesPerSecond` - The bytes written to the volume in a specified period of time.Unit: Bytes
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.EbsMetricName? = builder.name
    /**
     * The statistic of the utilization metric.
     *
     * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the `Maximum` statistic, which is the highest value observed during the specified period.
     *
     * The Compute Optimizer console displays graphs for some utilization metrics using the `Average` statistic, which is the value of `Sum` / `SampleCount` during the specified period. For more information, see [Viewing resource recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html) in the *Compute Optimizer User Guide*. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
     */
    public val statistic: aws.sdk.kotlin.services.computeoptimizer.model.MetricStatistic? = builder.statistic
    /**
     * The value of the utilization metric.
     */
    public val value: kotlin.Double = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EbsUtilizationMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsUtilizationMetric(")
        append("name=$name,")
        append("statistic=$statistic,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsUtilizationMetric

        if (name != other.name) return false
        if (statistic != other.statistic) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EbsUtilizationMetric = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the utilization metric.
         *
         * The following utilization metrics are available:
         * + `VolumeReadOpsPerSecond` - The completed read operations per second from the volume in a specified period of time.Unit: Count
         * + `VolumeWriteOpsPerSecond` - The completed write operations per second to the volume in a specified period of time.Unit: Count
         * + `VolumeReadBytesPerSecond` - The bytes read per second from the volume in a specified period of time.Unit: Bytes
         * + `VolumeWriteBytesPerSecond` - The bytes written to the volume in a specified period of time.Unit: Bytes
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.EbsMetricName? = null
        /**
         * The statistic of the utilization metric.
         *
         * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the `Maximum` statistic, which is the highest value observed during the specified period.
         *
         * The Compute Optimizer console displays graphs for some utilization metrics using the `Average` statistic, which is the value of `Sum` / `SampleCount` during the specified period. For more information, see [Viewing resource recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html) in the *Compute Optimizer User Guide*. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
         */
        public var statistic: aws.sdk.kotlin.services.computeoptimizer.model.MetricStatistic? = null
        /**
         * The value of the utilization metric.
         */
        public var value: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EbsUtilizationMetric) : this() {
            this.name = x.name
            this.statistic = x.statistic
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EbsUtilizationMetric = EbsUtilizationMetric(this)
    }
}
