// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a filter that returns a more specific list of Amazon Elastic Block Store (Amazon EBS) volume recommendations. Use this filter with the GetEBSVolumeRecommendations action.
 *
 * You can use `LambdaFunctionRecommendationFilter` with the GetLambdaFunctionRecommendations action, `JobFilter` with the DescribeRecommendationExportJobs action, and `Filter` with the GetAutoScalingGroupRecommendations and GetEC2InstanceRecommendations actions.
 */
public class EbsFilter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     *
     * Specify `Finding` to return recommendations with a specific finding classification (for example, `NotOptimized`).
     *
     * You can filter your Amazon EBS volume recommendations by `tag:key` and `tag-key` tags.
     *
     * A `tag:key` is a key and value combination of a tag assigned to your Amazon EBS volume recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Amazon EBS volume recommendations that have a tag with the key of `Owner` and the value of `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     *
     * A `tag-key` is the key of a tag assigned to your Amazon EBS volume recommendations. Use this filter to find all of your Amazon EBS volume recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Amazon EBS volume recommendations with a tag key value of `Owner` or without any tag keys assigned.
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.EbsFilterName? = builder.name
    /**
     * The value of the filter.
     *
     * The valid values are `Optimized`, or `NotOptimized`.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EbsFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsFilter(")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsFilter

        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EbsFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the filter.
         *
         * Specify `Finding` to return recommendations with a specific finding classification (for example, `NotOptimized`).
         *
         * You can filter your Amazon EBS volume recommendations by `tag:key` and `tag-key` tags.
         *
         * A `tag:key` is a key and value combination of a tag assigned to your Amazon EBS volume recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Amazon EBS volume recommendations that have a tag with the key of `Owner` and the value of `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         *
         * A `tag-key` is the key of a tag assigned to your Amazon EBS volume recommendations. Use this filter to find all of your Amazon EBS volume recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Amazon EBS volume recommendations with a tag key value of `Owner` or without any tag keys assigned.
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.EbsFilterName? = null
        /**
         * The value of the filter.
         *
         * The valid values are `Optimized`, or `NotOptimized`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EbsFilter) : this() {
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EbsFilter = EbsFilter(this)
    }
}
