// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a recommendation option for an Auto Scaling group.
 */
public class AutoScalingGroupRecommendationOption private constructor(builder: Builder) {
    /**
     * An array of objects that describe an Auto Scaling group configuration.
     */
    public val configuration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration? = builder.configuration
    /**
     * The level of effort required to migrate from the current instance type to the recommended instance type.
     *
     * For example, the migration effort is `Low` if Amazon EMR is the inferred workload type and an Amazon Web Services Graviton instance type is recommended. The migration effort is `Medium` if a workload type couldn't be inferred but an Amazon Web Services Graviton instance type is recommended. The migration effort is `VeryLow` if both the current and recommended instance types are of the same CPU architecture.
     */
    public val migrationEffort: aws.sdk.kotlin.services.computeoptimizer.model.MigrationEffort? = builder.migrationEffort
    /**
     * The performance risk of the Auto Scaling group configuration recommendation.
     *
     * Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.
     *
     * The value ranges from `0` - `4`, with `0` meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.
     */
    public val performanceRisk: kotlin.Double = builder.performanceRisk
    /**
     * An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.
     *
     * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
     */
    public val projectedUtilizationMetrics: List<UtilizationMetric>? = builder.projectedUtilizationMetrics
    /**
     * The rank of the Auto Scaling group recommendation option.
     *
     * The top recommendation option is ranked as `1`.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * An object that describes the savings opportunity for the Auto Scaling group recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroupRecommendationOption(")
        append("configuration=$configuration,")
        append("migrationEffort=$migrationEffort,")
        append("performanceRisk=$performanceRisk,")
        append("projectedUtilizationMetrics=$projectedUtilizationMetrics,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (migrationEffort?.hashCode() ?: 0)
        result = 31 * result + (performanceRisk.hashCode())
        result = 31 * result + (projectedUtilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroupRecommendationOption

        if (configuration != other.configuration) return false
        if (migrationEffort != other.migrationEffort) return false
        if (performanceRisk != other.performanceRisk) return false
        if (projectedUtilizationMetrics != other.projectedUtilizationMetrics) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendationOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects that describe an Auto Scaling group configuration.
         */
        public var configuration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration? = null
        /**
         * The level of effort required to migrate from the current instance type to the recommended instance type.
         *
         * For example, the migration effort is `Low` if Amazon EMR is the inferred workload type and an Amazon Web Services Graviton instance type is recommended. The migration effort is `Medium` if a workload type couldn't be inferred but an Amazon Web Services Graviton instance type is recommended. The migration effort is `VeryLow` if both the current and recommended instance types are of the same CPU architecture.
         */
        public var migrationEffort: aws.sdk.kotlin.services.computeoptimizer.model.MigrationEffort? = null
        /**
         * The performance risk of the Auto Scaling group configuration recommendation.
         *
         * Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.
         *
         * The value ranges from `0` - `4`, with `0` meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.
         */
        public var performanceRisk: kotlin.Double = 0.0
        /**
         * An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.
         *
         * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
         */
        public var projectedUtilizationMetrics: List<UtilizationMetric>? = null
        /**
         * The rank of the Auto Scaling group recommendation option.
         *
         * The top recommendation option is ranked as `1`.
         */
        public var rank: kotlin.Int = 0
        /**
         * An object that describes the savings opportunity for the Auto Scaling group recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendationOption) : this() {
            this.configuration = x.configuration
            this.migrationEffort = x.migrationEffort
            this.performanceRisk = x.performanceRisk
            this.projectedUtilizationMetrics = x.projectedUtilizationMetrics
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendationOption = AutoScalingGroupRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }
    }
}
