// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Auto Scaling group recommendation.
 */
public class AutoScalingGroupRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the Auto Scaling group.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public val autoScalingGroupArn: kotlin.String? = builder.autoScalingGroupArn
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * An array of objects that describe the current configuration of the Auto Scaling group.
     */
    public val currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration? = builder.currentConfiguration
    /**
     * The risk of the current Auto Scaling group not meeting the performance needs of its workloads. The higher the risk, the more likely the current Auto Scaling group configuration has insufficient capacity and cannot meet workload requirements.
     */
    public val currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = builder.currentPerformanceRisk
    /**
     * An object that describes the effective recommendation preferences for the Auto Scaling group.
     */
    public val effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences? = builder.effectiveRecommendationPreferences
    /**
     * The finding classification of the Auto Scaling group.
     *
     * Findings for Auto Scaling groups include:
     * + **`NotOptimized`**—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.
     * + **`Optimized`**—An Auto Scaling group is considered optimized when Compute Optimizer determines that the group is correctly provisioned to run your workload based on the chosen instance type. For optimized resources, Compute Optimizer might recommend a new generation instance type.
     */
    public val finding: aws.sdk.kotlin.services.computeoptimizer.model.Finding? = builder.finding
    /**
     * The applications that might be running on the instances in the Auto Scaling group as inferred by Compute Optimizer.
     *
     * Compute Optimizer can infer if one of the following applications might be running on the instances:
     * + `AmazonEmr` - Infers that Amazon EMR might be running on the instances.
     * + `ApacheCassandra` - Infers that Apache Cassandra might be running on the instances.
     * + `ApacheHadoop` - Infers that Apache Hadoop might be running on the instances.
     * + `Memcached` - Infers that Memcached might be running on the instances.
     * + `NGINX` - Infers that NGINX might be running on the instances.
     * + `PostgreSql` - Infers that PostgreSQL might be running on the instances.
     * + `Redis` - Infers that Redis might be running on the instances.
     * + `Kafka` - Infers that Kafka might be running on the instance.
     * + `SQLServer` - Infers that SQLServer might be running on the instance.
     */
    public val inferredWorkloadTypes: List<InferredWorkloadType>? = builder.inferredWorkloadTypes
    /**
     * The timestamp of when the Auto Scaling group recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days for which utilization metrics were analyzed for the Auto Scaling group.
     */
    public val lookBackPeriodInDays: kotlin.Double = builder.lookBackPeriodInDays
    /**
     * An array of objects that describe the recommendation options for the Auto Scaling group.
     */
    public val recommendationOptions: List<AutoScalingGroupRecommendationOption>? = builder.recommendationOptions
    /**
     * An array of objects that describe the utilization metrics of the Auto Scaling group.
     */
    public val utilizationMetrics: List<UtilizationMetric>? = builder.utilizationMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroupRecommendation(")
        append("accountId=$accountId,")
        append("autoScalingGroupArn=$autoScalingGroupArn,")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("currentConfiguration=$currentConfiguration,")
        append("currentPerformanceRisk=$currentPerformanceRisk,")
        append("effectiveRecommendationPreferences=$effectiveRecommendationPreferences,")
        append("finding=$finding,")
        append("inferredWorkloadTypes=$inferredWorkloadTypes,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookBackPeriodInDays=$lookBackPeriodInDays,")
        append("recommendationOptions=$recommendationOptions,")
        append("utilizationMetrics=$utilizationMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (autoScalingGroupArn?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroupName?.hashCode() ?: 0)
        result = 31 * result + (currentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (currentPerformanceRisk?.hashCode() ?: 0)
        result = 31 * result + (effectiveRecommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadTypes?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriodInDays.hashCode())
        result = 31 * result + (recommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroupRecommendation

        if (accountId != other.accountId) return false
        if (autoScalingGroupArn != other.autoScalingGroupArn) return false
        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (currentConfiguration != other.currentConfiguration) return false
        if (currentPerformanceRisk != other.currentPerformanceRisk) return false
        if (effectiveRecommendationPreferences != other.effectiveRecommendationPreferences) return false
        if (finding != other.finding) return false
        if (inferredWorkloadTypes != other.inferredWorkloadTypes) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (lookBackPeriodInDays != other.lookBackPeriodInDays) return false
        if (recommendationOptions != other.recommendationOptions) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID of the Auto Scaling group.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Auto Scaling group.
         */
        public var autoScalingGroupArn: kotlin.String? = null
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * An array of objects that describe the current configuration of the Auto Scaling group.
         */
        public var currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration? = null
        /**
         * The risk of the current Auto Scaling group not meeting the performance needs of its workloads. The higher the risk, the more likely the current Auto Scaling group configuration has insufficient capacity and cannot meet workload requirements.
         */
        public var currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = null
        /**
         * An object that describes the effective recommendation preferences for the Auto Scaling group.
         */
        public var effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences? = null
        /**
         * The finding classification of the Auto Scaling group.
         *
         * Findings for Auto Scaling groups include:
         * + **`NotOptimized`**—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.
         * + **`Optimized`**—An Auto Scaling group is considered optimized when Compute Optimizer determines that the group is correctly provisioned to run your workload based on the chosen instance type. For optimized resources, Compute Optimizer might recommend a new generation instance type.
         */
        public var finding: aws.sdk.kotlin.services.computeoptimizer.model.Finding? = null
        /**
         * The applications that might be running on the instances in the Auto Scaling group as inferred by Compute Optimizer.
         *
         * Compute Optimizer can infer if one of the following applications might be running on the instances:
         * + `AmazonEmr` - Infers that Amazon EMR might be running on the instances.
         * + `ApacheCassandra` - Infers that Apache Cassandra might be running on the instances.
         * + `ApacheHadoop` - Infers that Apache Hadoop might be running on the instances.
         * + `Memcached` - Infers that Memcached might be running on the instances.
         * + `NGINX` - Infers that NGINX might be running on the instances.
         * + `PostgreSql` - Infers that PostgreSQL might be running on the instances.
         * + `Redis` - Infers that Redis might be running on the instances.
         * + `Kafka` - Infers that Kafka might be running on the instance.
         * + `SQLServer` - Infers that SQLServer might be running on the instance.
         */
        public var inferredWorkloadTypes: List<InferredWorkloadType>? = null
        /**
         * The timestamp of when the Auto Scaling group recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days for which utilization metrics were analyzed for the Auto Scaling group.
         */
        public var lookBackPeriodInDays: kotlin.Double = 0.0
        /**
         * An array of objects that describe the recommendation options for the Auto Scaling group.
         */
        public var recommendationOptions: List<AutoScalingGroupRecommendationOption>? = null
        /**
         * An array of objects that describe the utilization metrics of the Auto Scaling group.
         */
        public var utilizationMetrics: List<UtilizationMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation) : this() {
            this.accountId = x.accountId
            this.autoScalingGroupArn = x.autoScalingGroupArn
            this.autoScalingGroupName = x.autoScalingGroupName
            this.currentConfiguration = x.currentConfiguration
            this.currentPerformanceRisk = x.currentPerformanceRisk
            this.effectiveRecommendationPreferences = x.effectiveRecommendationPreferences
            this.finding = x.finding
            this.inferredWorkloadTypes = x.inferredWorkloadTypes
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookBackPeriodInDays = x.lookBackPeriodInDays
            this.recommendationOptions = x.recommendationOptions
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupRecommendation = AutoScalingGroupRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration] inside the given [block]
         */
        public fun currentConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.currentConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences] inside the given [block]
         */
        public fun effectiveRecommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.effectiveRecommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences.invoke(block)
        }
    }
}
