// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.computeoptimizer.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.computeoptimizer.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.computeoptimizer.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.computeoptimizer.model.*
import aws.sdk.kotlin.services.computeoptimizer.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Compute Optimizer"
public const val ServiceApiVersion: String = "2019-11-01"
public const val SdkVersion: String = "0.28.2-beta"

internal class DefaultComputeOptimizerClient(override val config: ComputeOptimizerClient.Config) : ComputeOptimizerClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "compute-optimizer")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Deletes a recommendation preference, such as enhanced infrastructure metrics.
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun deleteRecommendationPreferences(input: DeleteRecommendationPreferencesRequest): DeleteRecommendationPreferencesResponse {
        val op = SdkHttpOperation.build<DeleteRecommendationPreferencesRequest, DeleteRecommendationPreferencesResponse> {
            serializer = DeleteRecommendationPreferencesOperationSerializer()
            deserializer = DeleteRecommendationPreferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteRecommendationPreferences"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteRecommendationPreferences-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes recommendation export jobs created in the last seven days.
     *
     * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs action to view your export jobs.
     */
    override suspend fun describeRecommendationExportJobs(input: DescribeRecommendationExportJobsRequest): DescribeRecommendationExportJobsResponse {
        val op = SdkHttpOperation.build<DescribeRecommendationExportJobsRequest, DescribeRecommendationExportJobsResponse> {
            serializer = DescribeRecommendationExportJobsOperationSerializer()
            deserializer = DescribeRecommendationExportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeRecommendationExportJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRecommendationExportJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Exports optimization recommendations for Auto Scaling groups.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportAutoScalingGroupRecommendations(input: ExportAutoScalingGroupRecommendationsRequest): ExportAutoScalingGroupRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportAutoScalingGroupRecommendationsRequest, ExportAutoScalingGroupRecommendationsResponse> {
            serializer = ExportAutoScalingGroupRecommendationsOperationSerializer()
            deserializer = ExportAutoScalingGroupRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ExportAutoScalingGroupRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportAutoScalingGroupRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Exports optimization recommendations for Amazon EBS volumes.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportEbsVolumeRecommendations(input: ExportEbsVolumeRecommendationsRequest): ExportEbsVolumeRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportEbsVolumeRecommendationsRequest, ExportEbsVolumeRecommendationsResponse> {
            serializer = ExportEBSVolumeRecommendationsOperationSerializer()
            deserializer = ExportEBSVolumeRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ExportEBSVolumeRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportEBSVolumeRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Exports optimization recommendations for Amazon EC2 instances.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportEc2InstanceRecommendations(input: ExportEc2InstanceRecommendationsRequest): ExportEc2InstanceRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportEc2InstanceRecommendationsRequest, ExportEc2InstanceRecommendationsResponse> {
            serializer = ExportEC2InstanceRecommendationsOperationSerializer()
            deserializer = ExportEC2InstanceRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ExportEC2InstanceRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportEC2InstanceRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Exports optimization recommendations for Amazon ECS services on Fargate.
     *
     * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportEcsServiceRecommendations(input: ExportEcsServiceRecommendationsRequest): ExportEcsServiceRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportEcsServiceRecommendationsRequest, ExportEcsServiceRecommendationsResponse> {
            serializer = ExportECSServiceRecommendationsOperationSerializer()
            deserializer = ExportECSServiceRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ExportECSServiceRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportECSServiceRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Exports optimization recommendations for Lambda functions.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     */
    override suspend fun exportLambdaFunctionRecommendations(input: ExportLambdaFunctionRecommendationsRequest): ExportLambdaFunctionRecommendationsResponse {
        val op = SdkHttpOperation.build<ExportLambdaFunctionRecommendationsRequest, ExportLambdaFunctionRecommendationsResponse> {
            serializer = ExportLambdaFunctionRecommendationsOperationSerializer()
            deserializer = ExportLambdaFunctionRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ExportLambdaFunctionRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ExportLambdaFunctionRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns Auto Scaling group recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun getAutoScalingGroupRecommendations(input: GetAutoScalingGroupRecommendationsRequest): GetAutoScalingGroupRecommendationsResponse {
        val op = SdkHttpOperation.build<GetAutoScalingGroupRecommendationsRequest, GetAutoScalingGroupRecommendationsResponse> {
            serializer = GetAutoScalingGroupRecommendationsOperationSerializer()
            deserializer = GetAutoScalingGroupRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetAutoScalingGroupRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetAutoScalingGroupRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun getEbsVolumeRecommendations(input: GetEbsVolumeRecommendationsRequest): GetEbsVolumeRecommendationsResponse {
        val op = SdkHttpOperation.build<GetEbsVolumeRecommendationsRequest, GetEbsVolumeRecommendationsResponse> {
            serializer = GetEBSVolumeRecommendationsOperationSerializer()
            deserializer = GetEBSVolumeRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEBSVolumeRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEBSVolumeRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns Amazon EC2 instance recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun getEc2InstanceRecommendations(input: GetEc2InstanceRecommendationsRequest): GetEc2InstanceRecommendationsResponse {
        val op = SdkHttpOperation.build<GetEc2InstanceRecommendationsRequest, GetEc2InstanceRecommendationsResponse> {
            serializer = GetEC2InstanceRecommendationsOperationSerializer()
            deserializer = GetEC2InstanceRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEC2InstanceRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEC2InstanceRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
     *
     * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned when you run this action. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
     */
    override suspend fun getEc2RecommendationProjectedMetrics(input: GetEc2RecommendationProjectedMetricsRequest): GetEc2RecommendationProjectedMetricsResponse {
        val op = SdkHttpOperation.build<GetEc2RecommendationProjectedMetricsRequest, GetEc2RecommendationProjectedMetricsResponse> {
            serializer = GetEC2RecommendationProjectedMetricsOperationSerializer()
            deserializer = GetEC2RecommendationProjectedMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEC2RecommendationProjectedMetrics"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEC2RecommendationProjectedMetrics-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the projected metrics of Amazon ECS service recommendations.
     */
    override suspend fun getEcsServiceRecommendationProjectedMetrics(input: GetEcsServiceRecommendationProjectedMetricsRequest): GetEcsServiceRecommendationProjectedMetricsResponse {
        val op = SdkHttpOperation.build<GetEcsServiceRecommendationProjectedMetricsRequest, GetEcsServiceRecommendationProjectedMetricsResponse> {
            serializer = GetECSServiceRecommendationProjectedMetricsOperationSerializer()
            deserializer = GetECSServiceRecommendationProjectedMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetECSServiceRecommendationProjectedMetrics"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetECSServiceRecommendationProjectedMetrics-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns Amazon ECS service recommendations.
     *
     *  Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun getEcsServiceRecommendations(input: GetEcsServiceRecommendationsRequest): GetEcsServiceRecommendationsResponse {
        val op = SdkHttpOperation.build<GetEcsServiceRecommendationsRequest, GetEcsServiceRecommendationsResponse> {
            serializer = GetECSServiceRecommendationsOperationSerializer()
            deserializer = GetECSServiceRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetECSServiceRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetECSServiceRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure metrics. Considers all applicable preferences that you might have set at the resource, account, and organization level.
     *
     * When you create a recommendation preference, you can set its status to `Active` or `Inactive`. Use this action to view the recommendation preferences that are in effect, or `Active`.
     */
    override suspend fun getEffectiveRecommendationPreferences(input: GetEffectiveRecommendationPreferencesRequest): GetEffectiveRecommendationPreferencesResponse {
        val op = SdkHttpOperation.build<GetEffectiveRecommendationPreferencesRequest, GetEffectiveRecommendationPreferencesResponse> {
            serializer = GetEffectiveRecommendationPreferencesOperationSerializer()
            deserializer = GetEffectiveRecommendationPreferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEffectiveRecommendationPreferences"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEffectiveRecommendationPreferences-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
     *
     * If the account is the management account of an organization, this action also confirms the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information about the enrollment status of member accounts of an organization.
     */
    override suspend fun getEnrollmentStatus(input: GetEnrollmentStatusRequest): GetEnrollmentStatusResponse {
        val op = SdkHttpOperation.build<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse> {
            serializer = GetEnrollmentStatusOperationSerializer()
            deserializer = GetEnrollmentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEnrollmentStatus"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEnrollmentStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.
     *
     * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
     */
    override suspend fun getEnrollmentStatusesForOrganization(input: GetEnrollmentStatusesForOrganizationRequest): GetEnrollmentStatusesForOrganizationResponse {
        val op = SdkHttpOperation.build<GetEnrollmentStatusesForOrganizationRequest, GetEnrollmentStatusesForOrganizationResponse> {
            serializer = GetEnrollmentStatusesForOrganizationOperationSerializer()
            deserializer = GetEnrollmentStatusesForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetEnrollmentStatusesForOrganization"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetEnrollmentStatusesForOrganization-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns Lambda function recommendations.
     *
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun getLambdaFunctionRecommendations(input: GetLambdaFunctionRecommendationsRequest): GetLambdaFunctionRecommendationsResponse {
        val op = SdkHttpOperation.build<GetLambdaFunctionRecommendationsRequest, GetLambdaFunctionRecommendationsResponse> {
            serializer = GetLambdaFunctionRecommendationsOperationSerializer()
            deserializer = GetLambdaFunctionRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetLambdaFunctionRecommendations"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetLambdaFunctionRecommendations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     *
     * Use the `scope` parameter to specify which preferences to return. You can specify to return preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon Resource Name (ARN).
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun getRecommendationPreferences(input: GetRecommendationPreferencesRequest): GetRecommendationPreferencesResponse {
        val op = SdkHttpOperation.build<GetRecommendationPreferencesRequest, GetRecommendationPreferencesResponse> {
            serializer = GetRecommendationPreferencesOperationSerializer()
            deserializer = GetRecommendationPreferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetRecommendationPreferences"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetRecommendationPreferences-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the optimization findings for an account.
     *
     * It returns the number of:
     * + Amazon EC2 instances in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
     * + Auto Scaling groups in an account that are `NotOptimized`, or `Optimized`.
     * + Amazon EBS volumes in an account that are `NotOptimized`, or `Optimized`.
     * + Lambda functions in an account that are `NotOptimized`, or `Optimized`.
     * + Amazon ECS services in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
     */
    override suspend fun getRecommendationSummaries(input: GetRecommendationSummariesRequest): GetRecommendationSummariesResponse {
        val op = SdkHttpOperation.build<GetRecommendationSummariesRequest, GetRecommendationSummariesResponse> {
            serializer = GetRecommendationSummariesOperationSerializer()
            deserializer = GetRecommendationSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetRecommendationSummaries"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetRecommendationSummaries-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced infrastructure metrics.
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun putRecommendationPreferences(input: PutRecommendationPreferencesRequest): PutRecommendationPreferencesResponse {
        val op = SdkHttpOperation.build<PutRecommendationPreferencesRequest, PutRecommendationPreferencesResponse> {
            serializer = PutRecommendationPreferencesOperationSerializer()
            deserializer = PutRecommendationPreferencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PutRecommendationPreferences"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutRecommendationPreferences-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     *
     * If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.
     *
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see [Controlling access with Amazon Web Services Identity and Access Management](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html) in the *Compute Optimizer User Guide*.
     *
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its data. For more information, see [Using Service-Linked Roles for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html) in the *Compute Optimizer User Guide*.
     */
    override suspend fun updateEnrollmentStatus(input: UpdateEnrollmentStatusRequest): UpdateEnrollmentStatusResponse {
        val op = SdkHttpOperation.build<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResponse> {
            serializer = UpdateEnrollmentStatusOperationSerializer()
            deserializer = UpdateEnrollmentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateEnrollmentStatus"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("ComputeOptimizerService", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEnrollmentStatus-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "compute-optimizer")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
