// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
 *
 * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
 *
 * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
 */
public class SavingsOpportunity private constructor(builder: Builder) {
    /**
     * An object that describes the estimated monthly savings amount possible, based on On-Demand instance pricing, by adopting Compute Optimizer recommendations for a given resource.
     */
    public val estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings? = builder.estimatedMonthlySavings
    /**
     * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer recommendations for a given resource.
     */
    public val savingsOpportunityPercentage: kotlin.Double = builder.savingsOpportunityPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SavingsOpportunity(")
        append("estimatedMonthlySavings=$estimatedMonthlySavings,")
        append("savingsOpportunityPercentage=$savingsOpportunityPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedMonthlySavings?.hashCode() ?: 0
        result = 31 * result + (savingsOpportunityPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SavingsOpportunity

        if (estimatedMonthlySavings != other.estimatedMonthlySavings) return false
        if (savingsOpportunityPercentage != other.savingsOpportunityPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that describes the estimated monthly savings amount possible, based on On-Demand instance pricing, by adopting Compute Optimizer recommendations for a given resource.
         */
        public var estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings? = null
        /**
         * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer recommendations for a given resource.
         */
        public var savingsOpportunityPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity) : this() {
            this.estimatedMonthlySavings = x.estimatedMonthlySavings
            this.savingsOpportunityPercentage = x.savingsOpportunityPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity = SavingsOpportunity(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings] inside the given [block]
         */
        public fun estimatedMonthlySavings(block: aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings.Builder.() -> kotlin.Unit) {
            this.estimatedMonthlySavings = aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings.invoke(block)
        }
    }
}
