// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.endpoints

import aws.sdk.kotlin.services.computeoptimizer.endpoints.internal.partition
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://compute-optimizer-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://compute-optimizer-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://compute-optimizer.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    if (
                        params.region == "ap-northeast-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.ap-northeast-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "ap-northeast-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.ap-northeast-2.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "ap-south-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.ap-south-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "ap-southeast-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.ap-southeast-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "ap-southeast-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.ap-southeast-2.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "ca-central-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.ca-central-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "eu-central-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.eu-central-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "eu-north-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.eu-north-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "eu-west-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.eu-west-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "eu-west-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.eu-west-2.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "eu-west-3"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.eu-west-3.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "sa-east-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.sa-east-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "us-east-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.us-east-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "us-east-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.us-east-2.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "us-west-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.us-west-1.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "us-west-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.us-west-2.amazonaws.com"),
                        )
                    }
                    if (
                        params.region == "cn-north-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.cn-north-1.amazonaws.com.cn"),
                        )
                    }
                    if (
                        params.region == "cn-northwest-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://compute-optimizer.cn-northwest-1.amazonaws.com.cn"),
                        )
                    }
                    return Endpoint(
                        Url.parse("https://compute-optimizer.${params.region}.${partitionResult?.dnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
