// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for a recommendations export job.
 *
 * You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see [Amazon S3 Bucket Policy for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html) in the *Compute Optimizer User Guide*.
 */
public class S3DestinationConfig private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket to use as the destination for an export job.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The Amazon S3 bucket prefix for an export job.
     */
    public val keyPrefix: kotlin.String? = builder.keyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DestinationConfig(")
        append("bucket=$bucket,")
        append("keyPrefix=$keyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (keyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DestinationConfig

        if (bucket != other.bucket) return false
        if (keyPrefix != other.keyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Amazon S3 bucket to use as the destination for an export job.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Amazon S3 bucket prefix for an export job.
         */
        public var keyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig) : this() {
            this.bucket = x.bucket
            this.keyPrefix = x.keyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig = S3DestinationConfig(this)
    }
}
