// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a recommendation preference.
 */
public class RecommendationPreferencesDetail private constructor(builder: Builder) {
    /**
     * The status of the enhanced infrastructure metrics recommendation preference.
     *
     * When the recommendations page is refreshed, a status of `Active` confirms that the preference is applied to the recommendations, and a status of `Inactive` confirms that the preference isn't yet applied to recommendations.
     *
     * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public val enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = builder.enhancedInfrastructureMetrics
    /**
     * An object that describes the external metrics recommendation preference.
     *
     *  If the preference is applied in the latest recommendation refresh, an object with a valid `source` value appears in the response. If the preference isn't applied to the recommendations already, then this object doesn't appear in the response.
     */
    public val externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = builder.externalMetricsPreference
    /**
     * The status of the inferred workload types recommendation preference.
     *
     * When the recommendations page is refreshed, a status of `Active` confirms that the preference is applied to the recommendations, and a status of `Inactive` confirms that the preference isn't yet applied to recommendations.
     */
    public val inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = builder.inferredWorkloadTypes
    /**
     * The target resource type of the recommendation preference to create.
     *
     * The `Ec2Instance` option encompasses standalone instances and instances that are part of Auto Scaling groups. The `AutoScalingGroup` option encompasses only instances that are part of an Auto Scaling group.
     */
    public val resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = builder.resourceType
    /**
     * An object that describes the scope of the recommendation preference.
     *
     * Recommendation preferences can be created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public val scope: aws.sdk.kotlin.services.computeoptimizer.model.Scope? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferencesDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationPreferencesDetail(")
        append("enhancedInfrastructureMetrics=$enhancedInfrastructureMetrics,")
        append("externalMetricsPreference=$externalMetricsPreference,")
        append("inferredWorkloadTypes=$inferredWorkloadTypes,")
        append("resourceType=$resourceType,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enhancedInfrastructureMetrics?.hashCode() ?: 0
        result = 31 * result + (externalMetricsPreference?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadTypes?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationPreferencesDetail

        if (enhancedInfrastructureMetrics != other.enhancedInfrastructureMetrics) return false
        if (externalMetricsPreference != other.externalMetricsPreference) return false
        if (inferredWorkloadTypes != other.inferredWorkloadTypes) return false
        if (resourceType != other.resourceType) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferencesDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status of the enhanced infrastructure metrics recommendation preference.
         *
         * When the recommendations page is refreshed, a status of `Active` confirms that the preference is applied to the recommendations, and a status of `Inactive` confirms that the preference isn't yet applied to recommendations.
         *
         * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         */
        public var enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = null
        /**
         * An object that describes the external metrics recommendation preference.
         *
         *  If the preference is applied in the latest recommendation refresh, an object with a valid `source` value appears in the response. If the preference isn't applied to the recommendations already, then this object doesn't appear in the response.
         */
        public var externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = null
        /**
         * The status of the inferred workload types recommendation preference.
         *
         * When the recommendations page is refreshed, a status of `Active` confirms that the preference is applied to the recommendations, and a status of `Inactive` confirms that the preference isn't yet applied to recommendations.
         */
        public var inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = null
        /**
         * The target resource type of the recommendation preference to create.
         *
         * The `Ec2Instance` option encompasses standalone instances and instances that are part of Auto Scaling groups. The `AutoScalingGroup` option encompasses only instances that are part of an Auto Scaling group.
         */
        public var resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = null
        /**
         * An object that describes the scope of the recommendation preference.
         *
         * Recommendation preferences can be created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         */
        public var scope: aws.sdk.kotlin.services.computeoptimizer.model.Scope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferencesDetail) : this() {
            this.enhancedInfrastructureMetrics = x.enhancedInfrastructureMetrics
            this.externalMetricsPreference = x.externalMetricsPreference
            this.inferredWorkloadTypes = x.inferredWorkloadTypes
            this.resourceType = x.resourceType
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferencesDetail = RecommendationPreferencesDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference] inside the given [block]
         */
        public fun externalMetricsPreference(block: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.Builder.() -> kotlin.Unit) {
            this.externalMetricsPreference = aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.Scope] inside the given [block]
         */
        public fun scope(block: aws.sdk.kotlin.services.computeoptimizer.model.Scope.Builder.() -> kotlin.Unit) {
            this.scope = aws.sdk.kotlin.services.computeoptimizer.model.Scope.invoke(block)
        }
    }
}
