// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetRecommendationSummariesRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account for which to return recommendation summaries.
     *
     * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return recommendation summaries.
     *
     * Only one account ID can be specified per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * The maximum number of recommendation summaries to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of recommendation summaries.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecommendationSummariesRequest(")
        append("accountIds=$accountIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecommendationSummariesRequest

        if (accountIds != other.accountIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account for which to return recommendation summaries.
         *
         * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return recommendation summaries.
         *
         * Only one account ID can be specified per request.
         */
        public var accountIds: List<String>? = null
        /**
         * The maximum number of recommendation summaries to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of recommendation summaries.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesRequest) : this() {
            this.accountIds = x.accountIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesRequest = GetRecommendationSummariesRequest(this)
    }
}
