// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.computeoptimizer.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.computeoptimizer.endpoints.EndpointProvider
import aws.sdk.kotlin.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.DeleteRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEcsServiceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEcsServiceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.UpdateEnrollmentStatusRequest
import aws.sdk.kotlin.services.computeoptimizer.model.UpdateEnrollmentStatusResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * Compute Optimizer is a service that analyzes the configuration and utilization metrics of your Amazon Web Services compute resources, such as Amazon EC2 instances, Amazon EC2 Auto Scaling groups, Lambda functions, Amazon EBS volumes, and Amazon ECS services on Fargate. It reports whether your resources are optimal, and generates optimization recommendations to reduce the cost and improve the performance of your workloads. Compute Optimizer also provides recent utilization metric data, in addition to projected utilization metric data for the recommendations, which you can use to evaluate which recommendation provides the best price-performance trade-off. The analysis of your usage patterns can help you decide when to move or resize your running resources, and still meet your performance and capacity requirements. For more information about Compute Optimizer, including the required permissions to use the service, see the [Compute Optimizer User Guide](https://docs.aws.amazon.com/compute-optimizer/latest/ug/).
 */
public interface ComputeOptimizerClient : SdkClient {

    override val serviceName: String
        get() = "Compute Optimizer"
    /**
     * ComputeOptimizerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ComputeOptimizerClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ComputeOptimizerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ComputeOptimizerClient = DefaultComputeOptimizerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Compute Optimizer")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes a recommendation preference, such as enhanced infrastructure metrics.
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun deleteRecommendationPreferences(input: DeleteRecommendationPreferencesRequest): DeleteRecommendationPreferencesResponse

    /**
     * Describes recommendation export jobs created in the last seven days.
     *
     * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs action to view your export jobs.
     */
    public suspend fun describeRecommendationExportJobs(input: DescribeRecommendationExportJobsRequest = DescribeRecommendationExportJobsRequest {}): DescribeRecommendationExportJobsResponse

    /**
     * Exports optimization recommendations for Auto Scaling groups.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportAutoScalingGroupRecommendations(input: ExportAutoScalingGroupRecommendationsRequest): ExportAutoScalingGroupRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon EBS volumes.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportEbsVolumeRecommendations(input: ExportEbsVolumeRecommendationsRequest): ExportEbsVolumeRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon EC2 instances.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportEc2InstanceRecommendations(input: ExportEc2InstanceRecommendationsRequest): ExportEc2InstanceRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon ECS services on Fargate.
     *
     * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportEcsServiceRecommendations(input: ExportEcsServiceRecommendationsRequest): ExportEcsServiceRecommendationsResponse

    /**
     * Exports optimization recommendations for Lambda functions.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportLambdaFunctionRecommendations(input: ExportLambdaFunctionRecommendationsRequest): ExportLambdaFunctionRecommendationsResponse

    /**
     * Returns Auto Scaling group recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getAutoScalingGroupRecommendations(input: GetAutoScalingGroupRecommendationsRequest = GetAutoScalingGroupRecommendationsRequest {}): GetAutoScalingGroupRecommendationsResponse

    /**
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getEbsVolumeRecommendations(input: GetEbsVolumeRecommendationsRequest = GetEbsVolumeRecommendationsRequest {}): GetEbsVolumeRecommendationsResponse

    /**
     * Returns Amazon EC2 instance recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getEc2InstanceRecommendations(input: GetEc2InstanceRecommendationsRequest = GetEc2InstanceRecommendationsRequest {}): GetEc2InstanceRecommendationsResponse

    /**
     * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
     *
     * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned when you run this action. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
     */
    public suspend fun getEc2RecommendationProjectedMetrics(input: GetEc2RecommendationProjectedMetricsRequest): GetEc2RecommendationProjectedMetricsResponse

    /**
     * Returns the projected metrics of Amazon ECS service recommendations.
     */
    public suspend fun getEcsServiceRecommendationProjectedMetrics(input: GetEcsServiceRecommendationProjectedMetricsRequest): GetEcsServiceRecommendationProjectedMetricsResponse

    /**
     * Returns Amazon ECS service recommendations.
     *
     *  Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getEcsServiceRecommendations(input: GetEcsServiceRecommendationsRequest = GetEcsServiceRecommendationsRequest {}): GetEcsServiceRecommendationsResponse

    /**
     * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure metrics. Considers all applicable preferences that you might have set at the resource, account, and organization level.
     *
     * When you create a recommendation preference, you can set its status to `Active` or `Inactive`. Use this action to view the recommendation preferences that are in effect, or `Active`.
     */
    public suspend fun getEffectiveRecommendationPreferences(input: GetEffectiveRecommendationPreferencesRequest): GetEffectiveRecommendationPreferencesResponse

    /**
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
     *
     * If the account is the management account of an organization, this action also confirms the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information about the enrollment status of member accounts of an organization.
     */
    public suspend fun getEnrollmentStatus(input: GetEnrollmentStatusRequest = GetEnrollmentStatusRequest {}): GetEnrollmentStatusResponse

    /**
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.
     *
     * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
     */
    public suspend fun getEnrollmentStatusesForOrganization(input: GetEnrollmentStatusesForOrganizationRequest = GetEnrollmentStatusesForOrganizationRequest {}): GetEnrollmentStatusesForOrganizationResponse

    /**
     * Returns Lambda function recommendations.
     *
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getLambdaFunctionRecommendations(input: GetLambdaFunctionRecommendationsRequest = GetLambdaFunctionRecommendationsRequest {}): GetLambdaFunctionRecommendationsResponse

    /**
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     *
     * Use the `scope` parameter to specify which preferences to return. You can specify to return preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon Resource Name (ARN).
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getRecommendationPreferences(input: GetRecommendationPreferencesRequest): GetRecommendationPreferencesResponse

    /**
     * Returns the optimization findings for an account.
     *
     * It returns the number of:
     * + Amazon EC2 instances in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
     * + Auto Scaling groups in an account that are `NotOptimized`, or `Optimized`.
     * + Amazon EBS volumes in an account that are `NotOptimized`, or `Optimized`.
     * + Lambda functions in an account that are `NotOptimized`, or `Optimized`.
     * + Amazon ECS services in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
     */
    public suspend fun getRecommendationSummaries(input: GetRecommendationSummariesRequest = GetRecommendationSummariesRequest {}): GetRecommendationSummariesResponse

    /**
     * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced infrastructure metrics.
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun putRecommendationPreferences(input: PutRecommendationPreferencesRequest): PutRecommendationPreferencesResponse

    /**
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     *
     * If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.
     *
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see [Controlling access with Amazon Web Services Identity and Access Management](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html) in the *Compute Optimizer User Guide*.
     *
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its data. For more information, see [Using Service-Linked Roles for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun updateEnrollmentStatus(input: UpdateEnrollmentStatusRequest): UpdateEnrollmentStatusResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ComputeOptimizerClient.withConfig(block: ComputeOptimizerClient.Config.Builder.() -> Unit): ComputeOptimizerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultComputeOptimizerClient(newConfig)
}

/**
 * Deletes a recommendation preference, such as enhanced infrastructure metrics.
 *
 * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.deleteRecommendationPreferences(crossinline block: DeleteRecommendationPreferencesRequest.Builder.() -> Unit): DeleteRecommendationPreferencesResponse = deleteRecommendationPreferences(DeleteRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Describes recommendation export jobs created in the last seven days.
 *
 * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs action to view your export jobs.
 */
public suspend inline fun ComputeOptimizerClient.describeRecommendationExportJobs(crossinline block: DescribeRecommendationExportJobsRequest.Builder.() -> Unit): DescribeRecommendationExportJobsResponse = describeRecommendationExportJobs(DescribeRecommendationExportJobsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Auto Scaling groups.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportAutoScalingGroupRecommendations(crossinline block: ExportAutoScalingGroupRecommendationsRequest.Builder.() -> Unit): ExportAutoScalingGroupRecommendationsResponse = exportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Amazon EBS volumes.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportEbsVolumeRecommendations(crossinline block: ExportEbsVolumeRecommendationsRequest.Builder.() -> Unit): ExportEbsVolumeRecommendationsResponse = exportEbsVolumeRecommendations(ExportEbsVolumeRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Amazon EC2 instances.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportEc2InstanceRecommendations(crossinline block: ExportEc2InstanceRecommendationsRequest.Builder.() -> Unit): ExportEc2InstanceRecommendationsResponse = exportEc2InstanceRecommendations(ExportEc2InstanceRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Amazon ECS services on Fargate.
 *
 * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportEcsServiceRecommendations(crossinline block: ExportEcsServiceRecommendationsRequest.Builder.() -> Unit): ExportEcsServiceRecommendationsResponse = exportEcsServiceRecommendations(ExportEcsServiceRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Lambda functions.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Lambda function export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportLambdaFunctionRecommendations(crossinline block: ExportLambdaFunctionRecommendationsRequest.Builder.() -> Unit): ExportLambdaFunctionRecommendationsResponse = exportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns Auto Scaling group recommendations.
 *
 * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getAutoScalingGroupRecommendations(crossinline block: GetAutoScalingGroupRecommendationsRequest.Builder.() -> Unit): GetAutoScalingGroupRecommendationsResponse = getAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
 *
 * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getEbsVolumeRecommendations(crossinline block: GetEbsVolumeRecommendationsRequest.Builder.() -> Unit): GetEbsVolumeRecommendationsResponse = getEbsVolumeRecommendations(GetEbsVolumeRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns Amazon EC2 instance recommendations.
 *
 * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getEc2InstanceRecommendations(crossinline block: GetEc2InstanceRecommendationsRequest.Builder.() -> Unit): GetEc2InstanceRecommendationsResponse = getEc2InstanceRecommendations(GetEc2InstanceRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
 *
 * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned when you run this action. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
 */
public suspend inline fun ComputeOptimizerClient.getEc2RecommendationProjectedMetrics(crossinline block: GetEc2RecommendationProjectedMetricsRequest.Builder.() -> Unit): GetEc2RecommendationProjectedMetricsResponse = getEc2RecommendationProjectedMetrics(GetEc2RecommendationProjectedMetricsRequest.Builder().apply(block).build())

/**
 * Returns the projected metrics of Amazon ECS service recommendations.
 */
public suspend inline fun ComputeOptimizerClient.getEcsServiceRecommendationProjectedMetrics(crossinline block: GetEcsServiceRecommendationProjectedMetricsRequest.Builder.() -> Unit): GetEcsServiceRecommendationProjectedMetricsResponse = getEcsServiceRecommendationProjectedMetrics(GetEcsServiceRecommendationProjectedMetricsRequest.Builder().apply(block).build())

/**
 * Returns Amazon ECS service recommendations.
 *
 *  Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getEcsServiceRecommendations(crossinline block: GetEcsServiceRecommendationsRequest.Builder.() -> Unit): GetEcsServiceRecommendationsResponse = getEcsServiceRecommendations(GetEcsServiceRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure metrics. Considers all applicable preferences that you might have set at the resource, account, and organization level.
 *
 * When you create a recommendation preference, you can set its status to `Active` or `Inactive`. Use this action to view the recommendation preferences that are in effect, or `Active`.
 */
public suspend inline fun ComputeOptimizerClient.getEffectiveRecommendationPreferences(crossinline block: GetEffectiveRecommendationPreferencesRequest.Builder.() -> Unit): GetEffectiveRecommendationPreferencesResponse = getEffectiveRecommendationPreferences(GetEffectiveRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
 *
 * If the account is the management account of an organization, this action also confirms the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information about the enrollment status of member accounts of an organization.
 */
public suspend inline fun ComputeOptimizerClient.getEnrollmentStatus(crossinline block: GetEnrollmentStatusRequest.Builder.() -> Unit): GetEnrollmentStatusResponse = getEnrollmentStatus(GetEnrollmentStatusRequest.Builder().apply(block).build())

/**
 * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.
 *
 * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
 */
public suspend inline fun ComputeOptimizerClient.getEnrollmentStatusesForOrganization(crossinline block: GetEnrollmentStatusesForOrganizationRequest.Builder.() -> Unit): GetEnrollmentStatusesForOrganizationResponse = getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationRequest.Builder().apply(block).build())

/**
 * Returns Lambda function recommendations.
 *
 * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getLambdaFunctionRecommendations(crossinline block: GetLambdaFunctionRecommendationsRequest.Builder.() -> Unit): GetLambdaFunctionRecommendationsResponse = getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
 *
 * Use the `scope` parameter to specify which preferences to return. You can specify to return preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon Resource Name (ARN).
 *
 * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getRecommendationPreferences(crossinline block: GetRecommendationPreferencesRequest.Builder.() -> Unit): GetRecommendationPreferencesResponse = getRecommendationPreferences(GetRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Returns the optimization findings for an account.
 *
 * It returns the number of:
 * + Amazon EC2 instances in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
 * + Auto Scaling groups in an account that are `NotOptimized`, or `Optimized`.
 * + Amazon EBS volumes in an account that are `NotOptimized`, or `Optimized`.
 * + Lambda functions in an account that are `NotOptimized`, or `Optimized`.
 * + Amazon ECS services in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
 */
public suspend inline fun ComputeOptimizerClient.getRecommendationSummaries(crossinline block: GetRecommendationSummariesRequest.Builder.() -> Unit): GetRecommendationSummariesResponse = getRecommendationSummaries(GetRecommendationSummariesRequest.Builder().apply(block).build())

/**
 * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced infrastructure metrics.
 *
 * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.putRecommendationPreferences(crossinline block: PutRecommendationPreferencesRequest.Builder.() -> Unit): PutRecommendationPreferencesResponse = putRecommendationPreferences(PutRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
 *
 * If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.
 *
 * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see [Controlling access with Amazon Web Services Identity and Access Management](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html) in the *Compute Optimizer User Guide*.
 *
 * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its data. For more information, see [Using Service-Linked Roles for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.updateEnrollmentStatus(crossinline block: UpdateEnrollmentStatusRequest.Builder.() -> Unit): UpdateEnrollmentStatusResponse = updateEnrollmentStatus(UpdateEnrollmentStatusRequest.Builder().apply(block).build())
