// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and
 * object keys of a recommendations export file, and its associated metadata file.
 */
class S3Destination private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket used as the destination of an export
     * file.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * The Amazon S3 bucket key of an export file.
     * The key uniquely identifies the object, or export file, in the S3 bucket.
     */
    val key: kotlin.String? = builder.key
    /**
     * The Amazon S3 bucket key of a metadata file.
     * The key uniquely identifies the object, or metadata file, in the S3 bucket.
     */
    val metadataKey: kotlin.String? = builder.metadataKey

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.S3Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Destination(")
        append("bucket=$bucket,")
        append("key=$key,")
        append("metadataKey=$metadataKey)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (metadataKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Destination

        if (bucket != other.bucket) return false
        if (key != other.key) return false
        if (metadataKey != other.metadataKey) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.S3Destination = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Amazon S3 bucket used as the destination of an export
         * file.
         */
        var bucket: kotlin.String? = null
        /**
         * The Amazon S3 bucket key of an export file.
         * The key uniquely identifies the object, or export file, in the S3 bucket.
         */
        var key: kotlin.String? = null
        /**
         * The Amazon S3 bucket key of a metadata file.
         * The key uniquely identifies the object, or metadata file, in the S3 bucket.
         */
        var metadataKey: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.S3Destination) : this() {
            this.bucket = x.bucket
            this.key = x.key
            this.metadataKey = x.metadataKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.S3Destination = S3Destination(this)
    }
}
