// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Lambda function recommendation.
 */
class LambdaFunctionRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the function.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * The amount of memory, in MB, that's allocated to the current function.
     */
    val currentMemorySize: kotlin.Int = builder.currentMemorySize
    /**
     * The risk of the current Lambda function not meeting the performance needs
     * of its workloads. The higher the risk, the more likely the current Lambda
     * function requires more memory.
     */
    val currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = builder.currentPerformanceRisk
    /**
     * The finding classification of the function.
     * Findings for functions include:
     *
     *
     *
     *
     * Optimized
     * — The function is
     * correctly provisioned to run your workload based on its current configuration
     * and its utilization history. This finding classification does not include
     * finding reason codes.
     *
     *
     *
     * NotOptimized
     * — The function is
     * performing at a higher level (over-provisioned) or at a lower level
     * (under-provisioned) than required for your workload because its current
     * configuration is not optimal. Over-provisioned resources might lead to
     * unnecessary infrastructure cost, and under-provisioned resources might lead to
     * poor application performance. This finding classification can include the
     * MemoryUnderprovisioned and MemoryUnderprovisioned
     * finding reason codes.
     *
     *
     *
     * Unavailable
     * — Compute Optimizer
     * was unable to generate a recommendation for the function. This could be because
     * the function has not accumulated sufficient metric data, or the function does
     * not qualify for a recommendation. This finding classification can include the
     * InsufficientData and Inconclusive finding reason
     * codes.
     *
     * Functions with a finding of unavailable are not returned unless you
     * specify the filter parameter with a value of
     * Unavailable in your
     * GetLambdaFunctionRecommendations request.
     */
    val finding: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendationFinding? = builder.finding
    /**
     * The reason for the finding classification of the function.
     *
     * Functions that have a finding classification of Optimized don't have
     * a finding reason code.
     *
     * Finding reason codes for functions include:
     *
     *
     *
     *
     * MemoryOverprovisioned
     * — The
     * function is over-provisioned when its memory configuration can be sized down
     * while still meeting the performance requirements of your workload. An
     * over-provisioned function might lead to unnecessary infrastructure cost. This
     * finding reason code is part of the NotOptimized finding
     * classification.
     *
     *
     *
     * MemoryUnderprovisioned
     * — The
     * function is under-provisioned when its memory configuration doesn't meet the
     * performance requirements of the workload. An under-provisioned function might
     * lead to poor application performance. This finding reason code is part of the
     * NotOptimized finding classification.
     *
     *
     *
     * InsufficientData
     * — The function
     * does not have sufficient metric data for Compute Optimizer to generate a
     * recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements in the Compute Optimizer User
     * Guide. This finding reason code is part of the
     * Unavailable finding classification.
     *
     *
     *
     * Inconclusive
     * — The function does
     * not qualify for a recommendation because Compute Optimizer cannot generate a
     * recommendation with a high degree of confidence. This finding reason code is
     * part of the Unavailable finding classification.
     */
    val findingReasonCodes: List<LambdaFunctionRecommendationFindingReasonCode>? = builder.findingReasonCodes
    /**
     * The Amazon Resource Name (ARN) of the current function.
     */
    val functionArn: kotlin.String? = builder.functionArn
    /**
     * The version number of the current function.
     */
    val functionVersion: kotlin.String? = builder.functionVersion
    /**
     * The timestamp of when the function recommendation was last generated.
     */
    val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days for which utilization metrics were analyzed for the
     * function.
     */
    val lookbackPeriodInDays: kotlin.Double = builder.lookbackPeriodInDays
    /**
     * An array of objects that describe the memory configuration recommendation options for
     * the function.
     */
    val memorySizeRecommendationOptions: List<LambdaFunctionMemoryRecommendationOption>? = builder.memorySizeRecommendationOptions
    /**
     * The number of times your function code was applied during the look-back period.
     */
    val numberOfInvocations: kotlin.Long = builder.numberOfInvocations
    /**
     * An array of objects that describe the utilization metrics of the function.
     */
    val utilizationMetrics: List<LambdaFunctionUtilizationMetric>? = builder.utilizationMetrics

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionRecommendation(")
        append("accountId=$accountId,")
        append("currentMemorySize=$currentMemorySize,")
        append("currentPerformanceRisk=$currentPerformanceRisk,")
        append("finding=$finding,")
        append("findingReasonCodes=$findingReasonCodes,")
        append("functionArn=$functionArn,")
        append("functionVersion=$functionVersion,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("memorySizeRecommendationOptions=$memorySizeRecommendationOptions,")
        append("numberOfInvocations=$numberOfInvocations,")
        append("utilizationMetrics=$utilizationMetrics)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentMemorySize)
        result = 31 * result + (currentPerformanceRisk?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (findingReasonCodes?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionVersion?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookbackPeriodInDays.hashCode())
        result = 31 * result + (memorySizeRecommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (numberOfInvocations.hashCode())
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionRecommendation

        if (accountId != other.accountId) return false
        if (currentMemorySize != other.currentMemorySize) return false
        if (currentPerformanceRisk != other.currentPerformanceRisk) return false
        if (finding != other.finding) return false
        if (findingReasonCodes != other.findingReasonCodes) return false
        if (functionArn != other.functionArn) return false
        if (functionVersion != other.functionVersion) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (lookbackPeriodInDays != other.lookbackPeriodInDays) return false
        if (memorySizeRecommendationOptions != other.memorySizeRecommendationOptions) return false
        if (numberOfInvocations != other.numberOfInvocations) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account ID of the function.
         */
        var accountId: kotlin.String? = null
        /**
         * The amount of memory, in MB, that's allocated to the current function.
         */
        var currentMemorySize: kotlin.Int = 0
        /**
         * The risk of the current Lambda function not meeting the performance needs
         * of its workloads. The higher the risk, the more likely the current Lambda
         * function requires more memory.
         */
        var currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = null
        /**
         * The finding classification of the function.
         * Findings for functions include:
         *
         *
         *
         *
         * Optimized
         * — The function is
         * correctly provisioned to run your workload based on its current configuration
         * and its utilization history. This finding classification does not include
         * finding reason codes.
         *
         *
         *
         * NotOptimized
         * — The function is
         * performing at a higher level (over-provisioned) or at a lower level
         * (under-provisioned) than required for your workload because its current
         * configuration is not optimal. Over-provisioned resources might lead to
         * unnecessary infrastructure cost, and under-provisioned resources might lead to
         * poor application performance. This finding classification can include the
         * MemoryUnderprovisioned and MemoryUnderprovisioned
         * finding reason codes.
         *
         *
         *
         * Unavailable
         * — Compute Optimizer
         * was unable to generate a recommendation for the function. This could be because
         * the function has not accumulated sufficient metric data, or the function does
         * not qualify for a recommendation. This finding classification can include the
         * InsufficientData and Inconclusive finding reason
         * codes.
         *
         * Functions with a finding of unavailable are not returned unless you
         * specify the filter parameter with a value of
         * Unavailable in your
         * GetLambdaFunctionRecommendations request.
         */
        var finding: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendationFinding? = null
        /**
         * The reason for the finding classification of the function.
         *
         * Functions that have a finding classification of Optimized don't have
         * a finding reason code.
         *
         * Finding reason codes for functions include:
         *
         *
         *
         *
         * MemoryOverprovisioned
         * — The
         * function is over-provisioned when its memory configuration can be sized down
         * while still meeting the performance requirements of your workload. An
         * over-provisioned function might lead to unnecessary infrastructure cost. This
         * finding reason code is part of the NotOptimized finding
         * classification.
         *
         *
         *
         * MemoryUnderprovisioned
         * — The
         * function is under-provisioned when its memory configuration doesn't meet the
         * performance requirements of the workload. An under-provisioned function might
         * lead to poor application performance. This finding reason code is part of the
         * NotOptimized finding classification.
         *
         *
         *
         * InsufficientData
         * — The function
         * does not have sufficient metric data for Compute Optimizer to generate a
         * recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
         * requirements in the Compute Optimizer User
         * Guide. This finding reason code is part of the
         * Unavailable finding classification.
         *
         *
         *
         * Inconclusive
         * — The function does
         * not qualify for a recommendation because Compute Optimizer cannot generate a
         * recommendation with a high degree of confidence. This finding reason code is
         * part of the Unavailable finding classification.
         */
        var findingReasonCodes: List<LambdaFunctionRecommendationFindingReasonCode>? = null
        /**
         * The Amazon Resource Name (ARN) of the current function.
         */
        var functionArn: kotlin.String? = null
        /**
         * The version number of the current function.
         */
        var functionVersion: kotlin.String? = null
        /**
         * The timestamp of when the function recommendation was last generated.
         */
        var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days for which utilization metrics were analyzed for the
         * function.
         */
        var lookbackPeriodInDays: kotlin.Double = 0.0
        /**
         * An array of objects that describe the memory configuration recommendation options for
         * the function.
         */
        var memorySizeRecommendationOptions: List<LambdaFunctionMemoryRecommendationOption>? = null
        /**
         * The number of times your function code was applied during the look-back period.
         */
        var numberOfInvocations: kotlin.Long = 0L
        /**
         * An array of objects that describe the utilization metrics of the function.
         */
        var utilizationMetrics: List<LambdaFunctionUtilizationMetric>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation) : this() {
            this.accountId = x.accountId
            this.currentMemorySize = x.currentMemorySize
            this.currentPerformanceRisk = x.currentPerformanceRisk
            this.finding = x.finding
            this.findingReasonCodes = x.findingReasonCodes
            this.functionArn = x.functionArn
            this.functionVersion = x.functionVersion
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.memorySizeRecommendationOptions = x.memorySizeRecommendationOptions
            this.numberOfInvocations = x.numberOfInvocations
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation = LambdaFunctionRecommendation(this)
    }
}
