// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a recommendation option for an Lambda function.
 */
class LambdaFunctionMemoryRecommendationOption private constructor(builder: Builder) {
    /**
     * The memory size, in MB, of the function recommendation option.
     */
    val memorySize: kotlin.Int = builder.memorySize
    /**
     * An array of objects that describe the projected utilization metrics of the function
     * recommendation option.
     */
    val projectedUtilizationMetrics: List<LambdaFunctionMemoryProjectedMetric>? = builder.projectedUtilizationMetrics
    /**
     * The rank of the function recommendation option.
     * The top recommendation option is ranked as 1.
     */
    val rank: kotlin.Int = builder.rank
    /**
     * An object that describes the savings opportunity for the Lambda function
     * recommendation option. Savings opportunity includes the estimated monthly savings amount
     * and percentage.
     */
    val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionMemoryRecommendationOption(")
        append("memorySize=$memorySize,")
        append("projectedUtilizationMetrics=$projectedUtilizationMetrics,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = memorySize
        result = 31 * result + (projectedUtilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionMemoryRecommendationOption

        if (memorySize != other.memorySize) return false
        if (projectedUtilizationMetrics != other.projectedUtilizationMetrics) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * The memory size, in MB, of the function recommendation option.
         */
        var memorySize: kotlin.Int = 0
        /**
         * An array of objects that describe the projected utilization metrics of the function
         * recommendation option.
         */
        var projectedUtilizationMetrics: List<LambdaFunctionMemoryProjectedMetric>? = null
        /**
         * The rank of the function recommendation option.
         * The top recommendation option is ranked as 1.
         */
        var rank: kotlin.Int = 0
        /**
         * An object that describes the savings opportunity for the Lambda function
         * recommendation option. Savings opportunity includes the estimated monthly savings amount
         * and percentage.
         */
        var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption) : this() {
            this.memorySize = x.memorySize
            this.projectedUtilizationMetrics = x.projectedUtilizationMetrics
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = LambdaFunctionMemoryRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }
    }
}
