// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a recommendation option for an Amazon EC2 instance.
 */
class InstanceRecommendationOption private constructor(builder: Builder) {
    /**
     * The instance type of the instance recommendation.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The level of effort required to migrate from the current instance type to the
     * recommended instance type.
     *
     * For example, the migration effort is Low if Amazon EMR is the
     * inferred workload type and an Amazon Web Services Graviton instance type is recommended.
     * The migration effort is Medium if a workload type couldn't be inferred but
     * an Amazon Web Services Graviton instance type is recommended. The migration effort is
     * VeryLow if both the current and recommended instance types are of the
     * same CPU architecture.
     */
    val migrationEffort: aws.sdk.kotlin.services.computeoptimizer.model.MigrationEffort? = builder.migrationEffort
    /**
     * The performance risk of the instance recommendation option.
     * Performance risk indicates the likelihood of the recommended instance type not meeting
     * the resource needs of your workload. Compute Optimizer calculates an individual
     * performance risk score for each specification of the recommended instance, including
     * CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
     * and network PPS.
     * The performance
     * risk of the recommended instance is calculated as the maximum performance risk score
     * across the analyzed resource specifications.
     * The value ranges from 0 - 4, with 0 meaning
     * that the recommended resource is predicted to always provide enough hardware capability.
     * The higher the performance risk is, the more likely you should validate whether the
     * recommendation will meet the performance requirements of your workload before migrating
     * your resource.
     */
    val performanceRisk: kotlin.Double = builder.performanceRisk
    /**
     * Describes the configuration differences between the current instance and the
     * recommended instance type. You should consider the configuration differences before
     * migrating your workloads from the current instance to the recommended instance type. The
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type
     * guide for Windows provide general guidance for getting started with an
     * instance migration.
     * Platform differences include:
     *
     *
     *
     *
     * Hypervisor
     * — The hypervisor of
     * the recommended instance type is different than that of the current instance.
     * For example, the recommended instance type uses a Nitro hypervisor and the
     * current instance uses a Xen hypervisor. The differences that you should consider
     * between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor section of the
     * Amazon EC2 frequently asked questions. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System in the Amazon EC2
     * User Guide for Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System in the Amazon EC2
     * User Guide for Windows.
     *
     *
     *
     * NetworkInterface
     * — The network
     * interface of the recommended instance type is different than that of the current
     * instance. For example, the recommended instance type supports enhanced
     * networking and the current instance might not. To enable enhanced networking for
     * the recommended instance type, you must install the Elastic Network Adapter
     * (ENA) driver or the Intel 82599 Virtual Function driver. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking
     * on Linux in the Amazon EC2 User Guide for
     * Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced
     * networking on Windows in the Amazon EC2 User Guide for
     * Windows.
     *
     *
     *
     * StorageInterface
     * — The storage
     * interface of the recommended instance type is different than that of the current
     * instance. For example, the recommended instance type uses an NVMe storage
     * interface and the current instance does not. To access NVMe volumes for the
     * recommended instance type, you will need to install or upgrade the NVMe driver.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on
     * Linux instances in the Amazon EC2 User Guide for
     * Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe
     * on Windows instances in the Amazon EC2 User Guide for
     * Windows.
     *
     *
     *
     * InstanceStoreAvailability
     * — The
     * recommended instance type does not support instance store volumes and the
     * current instance does. Before migrating, you might need to back up the data on
     * your instance store volumes if you want to preserve them. For more information,
     * see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance
     * to Amazon EBS? in the Amazon Web Services Premium
     * Support Knowledge Base. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2
     * instance store in the Amazon EC2 User Guide for
     * Linux, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2
     * instance store in the Amazon EC2 User Guide for
     * Windows.
     *
     *
     *
     * VirtualizationType
     * — The
     * recommended instance type uses the hardware virtual machine (HVM) virtualization
     * type and the current instance uses the paravirtual (PV) virtualization type. For
     * more information about the differences between these virtualization types, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI
     * virtualization types in the Amazon EC2 User Guide for
     * Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types in the Amazon EC2 User
     * Guide for Windows.
     *
     *
     *
     * Architecture
     * — The CPU
     * architecture between the recommended instance type and the current instance is
     * different. For example, the recommended instance type might use an Arm CPU
     * architecture and the current instance type might use a different one, such as
     * x86. Before migrating, you should consider recompiling the software on your
     * instance for the new architecture. Alternatively, you might switch to an Amazon
     * Machine Image (AMI) that supports the new architecture. For more information
     * about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types.
     */
    val platformDifferences: List<PlatformDifference>? = builder.platformDifferences
    /**
     * An array of objects that describe the projected utilization metrics of the instance
     * recommendation option.
     *
     * The Cpu and Memory metrics are the only projected
     * utilization metrics returned. Additionally, the Memory metric is
     * returned only for resources that have the unified CloudWatch agent installed
     * on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
     * Utilization with the CloudWatch Agent.
     */
    val projectedUtilizationMetrics: List<UtilizationMetric>? = builder.projectedUtilizationMetrics
    /**
     * The rank of the instance recommendation option.
     * The top recommendation option is ranked as 1.
     */
    val rank: kotlin.Int = builder.rank
    /**
     * An object that describes the savings opportunity for the instance recommendation
     * option. Savings opportunity includes the estimated monthly savings amount and
     * percentage.
     */
    val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceRecommendationOption(")
        append("instanceType=$instanceType,")
        append("migrationEffort=$migrationEffort,")
        append("performanceRisk=$performanceRisk,")
        append("platformDifferences=$platformDifferences,")
        append("projectedUtilizationMetrics=$projectedUtilizationMetrics,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceType?.hashCode() ?: 0
        result = 31 * result + (migrationEffort?.hashCode() ?: 0)
        result = 31 * result + (performanceRisk.hashCode())
        result = 31 * result + (platformDifferences?.hashCode() ?: 0)
        result = 31 * result + (projectedUtilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceRecommendationOption

        if (instanceType != other.instanceType) return false
        if (migrationEffort != other.migrationEffort) return false
        if (performanceRisk != other.performanceRisk) return false
        if (platformDifferences != other.platformDifferences) return false
        if (projectedUtilizationMetrics != other.projectedUtilizationMetrics) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * The instance type of the instance recommendation.
         */
        var instanceType: kotlin.String? = null
        /**
         * The level of effort required to migrate from the current instance type to the
         * recommended instance type.
         *
         * For example, the migration effort is Low if Amazon EMR is the
         * inferred workload type and an Amazon Web Services Graviton instance type is recommended.
         * The migration effort is Medium if a workload type couldn't be inferred but
         * an Amazon Web Services Graviton instance type is recommended. The migration effort is
         * VeryLow if both the current and recommended instance types are of the
         * same CPU architecture.
         */
        var migrationEffort: aws.sdk.kotlin.services.computeoptimizer.model.MigrationEffort? = null
        /**
         * The performance risk of the instance recommendation option.
         * Performance risk indicates the likelihood of the recommended instance type not meeting
         * the resource needs of your workload. Compute Optimizer calculates an individual
         * performance risk score for each specification of the recommended instance, including
         * CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput,
         * and network PPS.
         * The performance
         * risk of the recommended instance is calculated as the maximum performance risk score
         * across the analyzed resource specifications.
         * The value ranges from 0 - 4, with 0 meaning
         * that the recommended resource is predicted to always provide enough hardware capability.
         * The higher the performance risk is, the more likely you should validate whether the
         * recommendation will meet the performance requirements of your workload before migrating
         * your resource.
         */
        var performanceRisk: kotlin.Double = 0.0
        /**
         * Describes the configuration differences between the current instance and the
         * recommended instance type. You should consider the configuration differences before
         * migrating your workloads from the current instance to the recommended instance type. The
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type
         * guide for Windows provide general guidance for getting started with an
         * instance migration.
         * Platform differences include:
         *
         *
         *
         *
         * Hypervisor
         * — The hypervisor of
         * the recommended instance type is different than that of the current instance.
         * For example, the recommended instance type uses a Nitro hypervisor and the
         * current instance uses a Xen hypervisor. The differences that you should consider
         * between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor section of the
         * Amazon EC2 frequently asked questions. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System in the Amazon EC2
         * User Guide for Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System in the Amazon EC2
         * User Guide for Windows.
         *
         *
         *
         * NetworkInterface
         * — The network
         * interface of the recommended instance type is different than that of the current
         * instance. For example, the recommended instance type supports enhanced
         * networking and the current instance might not. To enable enhanced networking for
         * the recommended instance type, you must install the Elastic Network Adapter
         * (ENA) driver or the Intel 82599 Virtual Function driver. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking
         * on Linux in the Amazon EC2 User Guide for
         * Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced
         * networking on Windows in the Amazon EC2 User Guide for
         * Windows.
         *
         *
         *
         * StorageInterface
         * — The storage
         * interface of the recommended instance type is different than that of the current
         * instance. For example, the recommended instance type uses an NVMe storage
         * interface and the current instance does not. To access NVMe volumes for the
         * recommended instance type, you will need to install or upgrade the NVMe driver.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on
         * Linux instances in the Amazon EC2 User Guide for
         * Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe
         * on Windows instances in the Amazon EC2 User Guide for
         * Windows.
         *
         *
         *
         * InstanceStoreAvailability
         * — The
         * recommended instance type does not support instance store volumes and the
         * current instance does. Before migrating, you might need to back up the data on
         * your instance store volumes if you want to preserve them. For more information,
         * see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance
         * to Amazon EBS? in the Amazon Web Services Premium
         * Support Knowledge Base. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2
         * instance store in the Amazon EC2 User Guide for
         * Linux, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2
         * instance store in the Amazon EC2 User Guide for
         * Windows.
         *
         *
         *
         * VirtualizationType
         * — The
         * recommended instance type uses the hardware virtual machine (HVM) virtualization
         * type and the current instance uses the paravirtual (PV) virtualization type. For
         * more information about the differences between these virtualization types, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI
         * virtualization types in the Amazon EC2 User Guide for
         * Linux, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types in the Amazon EC2 User
         * Guide for Windows.
         *
         *
         *
         * Architecture
         * — The CPU
         * architecture between the recommended instance type and the current instance is
         * different. For example, the recommended instance type might use an Arm CPU
         * architecture and the current instance type might use a different one, such as
         * x86. Before migrating, you should consider recompiling the software on your
         * instance for the new architecture. Alternatively, you might switch to an Amazon
         * Machine Image (AMI) that supports the new architecture. For more information
         * about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types.
         */
        var platformDifferences: List<PlatformDifference>? = null
        /**
         * An array of objects that describe the projected utilization metrics of the instance
         * recommendation option.
         *
         * The Cpu and Memory metrics are the only projected
         * utilization metrics returned. Additionally, the Memory metric is
         * returned only for resources that have the unified CloudWatch agent installed
         * on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
         * Utilization with the CloudWatch Agent.
         */
        var projectedUtilizationMetrics: List<UtilizationMetric>? = null
        /**
         * The rank of the instance recommendation option.
         * The top recommendation option is ranked as 1.
         */
        var rank: kotlin.Int = 0
        /**
         * An object that describes the savings opportunity for the instance recommendation
         * option. Savings opportunity includes the estimated monthly savings amount and
         * percentage.
         */
        var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption) : this() {
            this.instanceType = x.instanceType
            this.migrationEffort = x.migrationEffort
            this.performanceRisk = x.performanceRisk
            this.platformDifferences = x.platformDifferences
            this.projectedUtilizationMetrics = x.projectedUtilizationMetrics
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption = InstanceRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }
    }
}
