// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



class GetLambdaFunctionRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account for which to return function
     * recommendations.
     * If your account is the management account of an organization, use this parameter to
     * specify the member account for which you want to return function recommendations.
     * Only one account ID can be specified per request.
     */
    val accountIds: List<String>? = builder.accountIds
    /**
     * An array of objects to specify a filter that returns a more specific list of function
     * recommendations.
     */
    val filters: List<LambdaFunctionRecommendationFilter>? = builder.filters
    /**
     * The Amazon Resource Name (ARN) of the functions for which to return
     * recommendations.
     * You can specify a qualified or unqualified ARN. If you specify an unqualified ARN
     * without a function version suffix, Compute Optimizer will return recommendations for the
     * latest ($LATEST) version of the function. If you specify a qualified ARN
     * with a version suffix, Compute Optimizer will return recommendations for the specified
     * function version. For more information about using function versions, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using
     * versions in the Lambda Developer
     * Guide.
     */
    val functionArns: List<String>? = builder.functionArns
    /**
     * The maximum number of function recommendations to return with a single request.
     * To retrieve the remaining results, make another request with the returned
     * nextToken value.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of function recommendations.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetLambdaFunctionRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("filters=$filters,")
        append("functionArns=$functionArns,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (functionArns?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetLambdaFunctionRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (filters != other.filters) return false
        if (functionArns != other.functionArns) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the Amazon Web Services account for which to return function
         * recommendations.
         * If your account is the management account of an organization, use this parameter to
         * specify the member account for which you want to return function recommendations.
         * Only one account ID can be specified per request.
         */
        var accountIds: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of function
         * recommendations.
         */
        var filters: List<LambdaFunctionRecommendationFilter>? = null
        /**
         * The Amazon Resource Name (ARN) of the functions for which to return
         * recommendations.
         * You can specify a qualified or unqualified ARN. If you specify an unqualified ARN
         * without a function version suffix, Compute Optimizer will return recommendations for the
         * latest ($LATEST) version of the function. If you specify a qualified ARN
         * with a version suffix, Compute Optimizer will return recommendations for the specified
         * function version. For more information about using function versions, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using
         * versions in the Lambda Developer
         * Guide.
         */
        var functionArns: List<String>? = null
        /**
         * The maximum number of function recommendations to return with a single request.
         * To retrieve the remaining results, make another request with the returned
         * nextToken value.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of function recommendations.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.filters = x.filters
            this.functionArns = x.functionArns
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest = GetLambdaFunctionRecommendationsRequest(this)
    }
}
