// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the effective recommendation preferences for a resource.
 */
class EffectiveRecommendationPreferences private constructor(builder: Builder) {
    /**
     * Describes the CPU vendor and architecture for an instance or Auto Scaling group
     * recommendations.
     * For example, when you specify AWS_ARM64 with:
     *
     *
     * A GetEC2InstanceRecommendations or GetAutoScalingGroupRecommendations request, Compute Optimizer
     * returns recommendations that consist of Graviton2 instance types only.
     *
     * A GetEC2RecommendationProjectedMetrics request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type
     * recommendations only.
     *
     * A ExportEC2InstanceRecommendations or ExportAutoScalingGroupRecommendations request, Compute Optimizer
     * exports recommendations that consist of Graviton2 instance types only.
     */
    val cpuVendorArchitectures: List<CpuVendorArchitecture>? = builder.cpuVendorArchitectures
    /**
     * Describes the activation status of the enhanced infrastructure metrics
     * preference.
     * A status of Active confirms that the preference is applied in the latest
     * recommendation refresh, and a status of Inactive confirms that it's not yet
     * applied to recommendations.
     * For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics in the Compute Optimizer User
     * Guide.
     */
    val enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = builder.enhancedInfrastructureMetrics
    /**
     * Describes the activation status of the inferred workload types preference.
     *
     * A status of Active confirms that the preference is applied in the latest
     * recommendation refresh. A status of Inactive confirms that it's not yet
     * applied to recommendations.
     */
    val inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = builder.inferredWorkloadTypes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EffectiveRecommendationPreferences(")
        append("cpuVendorArchitectures=$cpuVendorArchitectures,")
        append("enhancedInfrastructureMetrics=$enhancedInfrastructureMetrics,")
        append("inferredWorkloadTypes=$inferredWorkloadTypes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpuVendorArchitectures?.hashCode() ?: 0
        result = 31 * result + (enhancedInfrastructureMetrics?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EffectiveRecommendationPreferences

        if (cpuVendorArchitectures != other.cpuVendorArchitectures) return false
        if (enhancedInfrastructureMetrics != other.enhancedInfrastructureMetrics) return false
        if (inferredWorkloadTypes != other.inferredWorkloadTypes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences = Builder(this).apply(block).build()

    class Builder {
        /**
         * Describes the CPU vendor and architecture for an instance or Auto Scaling group
         * recommendations.
         * For example, when you specify AWS_ARM64 with:
         *
         *
         * A GetEC2InstanceRecommendations or GetAutoScalingGroupRecommendations request, Compute Optimizer
         * returns recommendations that consist of Graviton2 instance types only.
         *
         * A GetEC2RecommendationProjectedMetrics request, Compute Optimizer returns projected utilization metrics for Graviton2 instance type
         * recommendations only.
         *
         * A ExportEC2InstanceRecommendations or ExportAutoScalingGroupRecommendations request, Compute Optimizer
         * exports recommendations that consist of Graviton2 instance types only.
         */
        var cpuVendorArchitectures: List<CpuVendorArchitecture>? = null
        /**
         * Describes the activation status of the enhanced infrastructure metrics
         * preference.
         * A status of Active confirms that the preference is applied in the latest
         * recommendation refresh, and a status of Inactive confirms that it's not yet
         * applied to recommendations.
         * For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics in the Compute Optimizer User
         * Guide.
         */
        var enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = null
        /**
         * Describes the activation status of the inferred workload types preference.
         *
         * A status of Active confirms that the preference is applied in the latest
         * recommendation refresh. A status of Inactive confirms that it's not yet
         * applied to recommendations.
         */
        var inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences) : this() {
            this.cpuVendorArchitectures = x.cpuVendorArchitectures
            this.enhancedInfrastructureMetrics = x.enhancedInfrastructureMetrics
            this.inferredWorkloadTypes = x.inferredWorkloadTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences = EffectiveRecommendationPreferences(this)
    }
}
