// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the savings opportunity for DB instance recommendations after applying Savings Plans discounts.
 *
 *  Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.
 */
public class RdsInstanceSavingsOpportunityAfterDiscounts private constructor(builder: Builder) {
    /**
     * The estimated monthly savings possible by adopting Compute Optimizer’s DB instance recommendations. This includes any applicable Savings Plans discounts.
     */
    public val estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceEstimatedMonthlySavings? = builder.estimatedMonthlySavings
    /**
     * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s DB instance recommendations. This includes any applicable Savings Plans discounts.
     */
    public val savingsOpportunityPercentage: kotlin.Double = builder.savingsOpportunityPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsInstanceSavingsOpportunityAfterDiscounts(")
        append("estimatedMonthlySavings=$estimatedMonthlySavings,")
        append("savingsOpportunityPercentage=$savingsOpportunityPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedMonthlySavings?.hashCode() ?: 0
        result = 31 * result + (savingsOpportunityPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsInstanceSavingsOpportunityAfterDiscounts

        if (estimatedMonthlySavings != other.estimatedMonthlySavings) return false
        if (!(savingsOpportunityPercentage?.equals(other.savingsOpportunityPercentage) ?: (other.savingsOpportunityPercentage == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The estimated monthly savings possible by adopting Compute Optimizer’s DB instance recommendations. This includes any applicable Savings Plans discounts.
         */
        public var estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceEstimatedMonthlySavings? = null
        /**
         * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s DB instance recommendations. This includes any applicable Savings Plans discounts.
         */
        public var savingsOpportunityPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts) : this() {
            this.estimatedMonthlySavings = x.estimatedMonthlySavings
            this.savingsOpportunityPercentage = x.savingsOpportunityPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts = RdsInstanceSavingsOpportunityAfterDiscounts(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceEstimatedMonthlySavings] inside the given [block]
         */
        public fun estimatedMonthlySavings(block: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceEstimatedMonthlySavings.Builder.() -> kotlin.Unit) {
            this.estimatedMonthlySavings = aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceEstimatedMonthlySavings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
