// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the effective recommendation preferences for Amazon Aurora and RDS databases.
 */
public class RdsEffectiveRecommendationPreferences private constructor(builder: Builder) {
    /**
     * Describes the CPU vendor and architecture for DB instance recommendations.
     */
    public val cpuVendorArchitectures: List<CpuVendorArchitecture>? = builder.cpuVendorArchitectures
    /**
     * Describes the activation status of the enhanced infrastructure metrics preference.
     *
     * A status of `Active` confirms that the preference is applied in the latest recommendation refresh, and a status of `Inactive` confirms that it's not yet applied to recommendations.
     *
     * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public val enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = builder.enhancedInfrastructureMetrics
    /**
     * The number of days the utilization metrics of the DB instance are analyzed.
     */
    public val lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = builder.lookBackPeriod
    /**
     * Describes the savings estimation mode preference applied for calculating savings opportunity for DB instances.
     */
    public val savingsEstimationMode: aws.sdk.kotlin.services.computeoptimizer.model.RdsSavingsEstimationMode? = builder.savingsEstimationMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsEffectiveRecommendationPreferences(")
        append("cpuVendorArchitectures=$cpuVendorArchitectures,")
        append("enhancedInfrastructureMetrics=$enhancedInfrastructureMetrics,")
        append("lookBackPeriod=$lookBackPeriod,")
        append("savingsEstimationMode=$savingsEstimationMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpuVendorArchitectures?.hashCode() ?: 0
        result = 31 * result + (enhancedInfrastructureMetrics?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriod?.hashCode() ?: 0)
        result = 31 * result + (savingsEstimationMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsEffectiveRecommendationPreferences

        if (cpuVendorArchitectures != other.cpuVendorArchitectures) return false
        if (enhancedInfrastructureMetrics != other.enhancedInfrastructureMetrics) return false
        if (lookBackPeriod != other.lookBackPeriod) return false
        if (savingsEstimationMode != other.savingsEstimationMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the CPU vendor and architecture for DB instance recommendations.
         */
        public var cpuVendorArchitectures: List<CpuVendorArchitecture>? = null
        /**
         * Describes the activation status of the enhanced infrastructure metrics preference.
         *
         * A status of `Active` confirms that the preference is applied in the latest recommendation refresh, and a status of `Inactive` confirms that it's not yet applied to recommendations.
         *
         * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         */
        public var enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = null
        /**
         * The number of days the utilization metrics of the DB instance are analyzed.
         */
        public var lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = null
        /**
         * Describes the savings estimation mode preference applied for calculating savings opportunity for DB instances.
         */
        public var savingsEstimationMode: aws.sdk.kotlin.services.computeoptimizer.model.RdsSavingsEstimationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences) : this() {
            this.cpuVendorArchitectures = x.cpuVendorArchitectures
            this.enhancedInfrastructureMetrics = x.enhancedInfrastructureMetrics
            this.lookBackPeriod = x.lookBackPeriod
            this.savingsEstimationMode = x.savingsEstimationMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences = RdsEffectiveRecommendationPreferences(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RdsSavingsEstimationMode] inside the given [block]
         */
        public fun savingsEstimationMode(block: aws.sdk.kotlin.services.computeoptimizer.model.RdsSavingsEstimationMode.Builder.() -> kotlin.Unit) {
            this.savingsEstimationMode = aws.sdk.kotlin.services.computeoptimizer.model.RdsSavingsEstimationMode.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
