// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The estimated monthly savings after you adjust the configurations of your instances running on the inferred workload types to the recommended configurations. If the `inferredWorkloadTypes` list contains multiple entries, then the savings are the sum of the monthly savings from instances that run the exact combination of the inferred workload types.
 */
public class InferredWorkloadSaving private constructor(builder: Builder) {
    /**
     * An object that describes the estimated monthly savings amount possible by adopting Compute Optimizer recommendations for a given resource. This is based on the On-Demand instance pricing.
     */
    public val estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings? = builder.estimatedMonthlySavings
    /**
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     *
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * + `AmazonEmr` - Infers that Amazon EMR might be running on the instance.
     * + `ApacheCassandra` - Infers that Apache Cassandra might be running on the instance.
     * + `ApacheHadoop` - Infers that Apache Hadoop might be running on the instance.
     * + `Memcached` - Infers that Memcached might be running on the instance.
     * + `NGINX` - Infers that NGINX might be running on the instance.
     * + `PostgreSql` - Infers that PostgreSQL might be running on the instance.
     * + `Redis` - Infers that Redis might be running on the instance.
     * + `Kafka` - Infers that Kafka might be running on the instance.
     * + `SQLServer` - Infers that SQLServer might be running on the instance.
     */
    public val inferredWorkloadTypes: List<InferredWorkloadType>? = builder.inferredWorkloadTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadSaving = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferredWorkloadSaving(")
        append("estimatedMonthlySavings=$estimatedMonthlySavings,")
        append("inferredWorkloadTypes=$inferredWorkloadTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedMonthlySavings?.hashCode() ?: 0
        result = 31 * result + (inferredWorkloadTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferredWorkloadSaving

        if (estimatedMonthlySavings != other.estimatedMonthlySavings) return false
        if (inferredWorkloadTypes != other.inferredWorkloadTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadSaving = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that describes the estimated monthly savings amount possible by adopting Compute Optimizer recommendations for a given resource. This is based on the On-Demand instance pricing.
         */
        public var estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings? = null
        /**
         * The applications that might be running on the instance as inferred by Compute Optimizer.
         *
         * Compute Optimizer can infer if one of the following applications might be running on the instance:
         * + `AmazonEmr` - Infers that Amazon EMR might be running on the instance.
         * + `ApacheCassandra` - Infers that Apache Cassandra might be running on the instance.
         * + `ApacheHadoop` - Infers that Apache Hadoop might be running on the instance.
         * + `Memcached` - Infers that Memcached might be running on the instance.
         * + `NGINX` - Infers that NGINX might be running on the instance.
         * + `PostgreSql` - Infers that PostgreSQL might be running on the instance.
         * + `Redis` - Infers that Redis might be running on the instance.
         * + `Kafka` - Infers that Kafka might be running on the instance.
         * + `SQLServer` - Infers that SQLServer might be running on the instance.
         */
        public var inferredWorkloadTypes: List<InferredWorkloadType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadSaving) : this() {
            this.estimatedMonthlySavings = x.estimatedMonthlySavings
            this.inferredWorkloadTypes = x.inferredWorkloadTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadSaving = InferredWorkloadSaving(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings] inside the given [block]
         */
        public fun estimatedMonthlySavings(block: aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings.Builder.() -> kotlin.Unit) {
            this.estimatedMonthlySavings = aws.sdk.kotlin.services.computeoptimizer.model.EstimatedMonthlySavings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
