// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Idle resource recommendation.
 */
public class IdleRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the idle resource.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The finding classification of an idle resource.
     */
    public val finding: aws.sdk.kotlin.services.computeoptimizer.model.IdleFinding? = builder.finding
    /**
     * A summary of the findings for the resource.
     */
    public val findingDescription: kotlin.String? = builder.findingDescription
    /**
     * The timestamp of when the idle resource recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days the idle resource utilization metrics were analyzed.
     */
    public val lookBackPeriodInDays: kotlin.Double = builder.lookBackPeriodInDays
    /**
     * The ARN of the current idle resource.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The unique identifier for the resource.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The type of resource that is idle.
     */
    public val resourceType: aws.sdk.kotlin.services.computeoptimizer.model.IdleRecommendationResourceType? = builder.resourceType
    /**
     * The savings opportunity for the idle resource.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunity? = builder.savingsOpportunity
    /**
     * The savings opportunity for the idle resource after any applying discounts.
     */
    public val savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunityAfterDiscounts? = builder.savingsOpportunityAfterDiscounts
    /**
     * A list of tags assigned to your idle resource recommendations.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An array of objects that describe the utilization metrics of the idle resource.
     */
    public val utilizationMetrics: List<IdleUtilizationMetric>? = builder.utilizationMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.IdleRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdleRecommendation(")
        append("accountId=$accountId,")
        append("finding=$finding,")
        append("findingDescription=$findingDescription,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookBackPeriodInDays=$lookBackPeriodInDays,")
        append("resourceArn=$resourceArn,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("savingsOpportunity=$savingsOpportunity,")
        append("savingsOpportunityAfterDiscounts=$savingsOpportunityAfterDiscounts,")
        append("tags=$tags,")
        append("utilizationMetrics=$utilizationMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (findingDescription?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriodInDays.hashCode())
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunityAfterDiscounts?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdleRecommendation

        if (accountId != other.accountId) return false
        if (finding != other.finding) return false
        if (findingDescription != other.findingDescription) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (!(lookBackPeriodInDays?.equals(other.lookBackPeriodInDays) ?: (other.lookBackPeriodInDays == null))) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (savingsOpportunity != other.savingsOpportunity) return false
        if (savingsOpportunityAfterDiscounts != other.savingsOpportunityAfterDiscounts) return false
        if (tags != other.tags) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.IdleRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the idle resource.
         */
        public var accountId: kotlin.String? = null
        /**
         * The finding classification of an idle resource.
         */
        public var finding: aws.sdk.kotlin.services.computeoptimizer.model.IdleFinding? = null
        /**
         * A summary of the findings for the resource.
         */
        public var findingDescription: kotlin.String? = null
        /**
         * The timestamp of when the idle resource recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days the idle resource utilization metrics were analyzed.
         */
        public var lookBackPeriodInDays: kotlin.Double = 0.0
        /**
         * The ARN of the current idle resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The unique identifier for the resource.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The type of resource that is idle.
         */
        public var resourceType: aws.sdk.kotlin.services.computeoptimizer.model.IdleRecommendationResourceType? = null
        /**
         * The savings opportunity for the idle resource.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunity? = null
        /**
         * The savings opportunity for the idle resource after any applying discounts.
         */
        public var savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunityAfterDiscounts? = null
        /**
         * A list of tags assigned to your idle resource recommendations.
         */
        public var tags: List<Tag>? = null
        /**
         * An array of objects that describe the utilization metrics of the idle resource.
         */
        public var utilizationMetrics: List<IdleUtilizationMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.IdleRecommendation) : this() {
            this.accountId = x.accountId
            this.finding = x.finding
            this.findingDescription = x.findingDescription
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookBackPeriodInDays = x.lookBackPeriodInDays
            this.resourceArn = x.resourceArn
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.savingsOpportunity = x.savingsOpportunity
            this.savingsOpportunityAfterDiscounts = x.savingsOpportunityAfterDiscounts
            this.tags = x.tags
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.IdleRecommendation = IdleRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunityAfterDiscounts] inside the given [block]
         */
        public fun savingsOpportunityAfterDiscounts(block: aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunityAfterDiscounts.Builder.() -> kotlin.Unit) {
            this.savingsOpportunityAfterDiscounts = aws.sdk.kotlin.services.computeoptimizer.model.IdleSavingsOpportunityAfterDiscounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
