// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetRdsDatabaseRecommendationsRequest private constructor(builder: Builder) {
    /**
     * Return the Amazon Aurora and RDS database recommendations to the specified Amazon Web Services account IDs.
     *
     * If your account is the management account or the delegated administrator of an organization, use this parameter to return the Amazon Aurora and RDS database recommendations to specific member accounts.
     *
     * You can only specify one account ID per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * An array of objects to specify a filter that returns a more specific list of Amazon Aurora and RDS database recommendations.
     */
    public val filters: List<RdsdbRecommendationFilter>? = builder.filters
    /**
     * The maximum number of Amazon Aurora and RDS database recommendations to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of Amazon Aurora and RDS database recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Describes the recommendation preferences to return in the response of a GetAutoScalingGroupRecommendations, GetEC2InstanceRecommendations, GetEC2RecommendationProjectedMetrics, GetRDSDatabaseRecommendations, and GetRDSDatabaseRecommendationProjectedMetrics request.
     */
    public val recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = builder.recommendationPreferences
    /**
     * The ARN that identifies the Amazon Aurora or RDS database.
     *
     *  The following is the format of the ARN:
     *
     * `arn:aws:rds:{region}:{accountId}:db:{resourceName}`
     *
     *  The following is the format of a DB Cluster ARN:
     *
     * `arn:aws:rds:{region}:{accountId}:cluster:{resourceName}`
     */
    public val resourceArns: List<String>? = builder.resourceArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRdsDatabaseRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("recommendationPreferences=$recommendationPreferences,")
        append("resourceArns=$resourceArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (recommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRdsDatabaseRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (recommendationPreferences != other.recommendationPreferences) return false
        if (resourceArns != other.resourceArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Return the Amazon Aurora and RDS database recommendations to the specified Amazon Web Services account IDs.
         *
         * If your account is the management account or the delegated administrator of an organization, use this parameter to return the Amazon Aurora and RDS database recommendations to specific member accounts.
         *
         * You can only specify one account ID per request.
         */
        public var accountIds: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of Amazon Aurora and RDS database recommendations.
         */
        public var filters: List<RdsdbRecommendationFilter>? = null
        /**
         * The maximum number of Amazon Aurora and RDS database recommendations to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of Amazon Aurora and RDS database recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Describes the recommendation preferences to return in the response of a GetAutoScalingGroupRecommendations, GetEC2InstanceRecommendations, GetEC2RecommendationProjectedMetrics, GetRDSDatabaseRecommendations, and GetRDSDatabaseRecommendationProjectedMetrics request.
         */
        public var recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = null
        /**
         * The ARN that identifies the Amazon Aurora or RDS database.
         *
         *  The following is the format of the ARN:
         *
         * `arn:aws:rds:{region}:{accountId}:db:{resourceName}`
         *
         *  The following is the format of a DB Cluster ARN:
         *
         * `arn:aws:rds:{region}:{accountId}:cluster:{resourceName}`
         */
        public var resourceArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.recommendationPreferences = x.recommendationPreferences
            this.resourceArns = x.resourceArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationsRequest = GetRdsDatabaseRecommendationsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences] inside the given [block]
         */
        public fun recommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.recommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
