// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of the recommended RDS storage.
 */
public class DbStorageConfiguration private constructor(builder: Builder) {
    /**
     * The size of the DB storage in gigabytes (GB).
     */
    public val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * The provisioned IOPs of the DB storage.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     */
    public val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * The storage throughput of the DB storage.
     */
    public val storageThroughput: kotlin.Int? = builder.storageThroughput
    /**
     * The type of DB storage.
     */
    public val storageType: kotlin.String? = builder.storageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbStorageConfiguration(")
        append("allocatedStorage=$allocatedStorage,")
        append("iops=$iops,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("storageThroughput=$storageThroughput,")
        append("storageType=$storageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (storageThroughput ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbStorageConfiguration

        if (allocatedStorage != other.allocatedStorage) return false
        if (iops != other.iops) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (storageThroughput != other.storageThroughput) return false
        if (storageType != other.storageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The size of the DB storage in gigabytes (GB).
         */
        public var allocatedStorage: kotlin.Int = 0
        /**
         * The provisioned IOPs of the DB storage.
         */
        public var iops: kotlin.Int? = null
        /**
         * The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         */
        public var maxAllocatedStorage: kotlin.Int? = null
        /**
         * The storage throughput of the DB storage.
         */
        public var storageThroughput: kotlin.Int? = null
        /**
         * The type of DB storage.
         */
        public var storageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.iops = x.iops
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.storageThroughput = x.storageThroughput
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration = DbStorageConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
