// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration of an EC2 Auto Scaling group.
 */
public class AutoScalingGroupConfiguration private constructor(builder: Builder) {
    /**
     * Describes the allocation strategy that the EC2 Auto Scaling group uses. This field is only available for EC2 Auto Scaling groups with mixed instance types.
     */
    public val allocationStrategy: aws.sdk.kotlin.services.computeoptimizer.model.AllocationStrategy? = builder.allocationStrategy
    /**
     * The desired capacity, or number of instances, for the EC2 Auto Scaling group.
     */
    public val desiredCapacity: kotlin.Int = builder.desiredCapacity
    /**
     * Describes the projected percentage reduction in instance hours after adopting the recommended configuration. This field is only available for EC2 Auto Scaling groups with scaling policies.
     */
    public val estimatedInstanceHourReductionPercentage: kotlin.Double? = builder.estimatedInstanceHourReductionPercentage
    /**
     * The instance type for the EC2 Auto Scaling group.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The maximum size, or maximum number of instances, for the EC2 Auto Scaling group.
     */
    public val maxSize: kotlin.Int = builder.maxSize
    /**
     * The minimum size, or minimum number of instances, for the EC2 Auto Scaling group.
     */
    public val minSize: kotlin.Int = builder.minSize
    /**
     * List the instance types within an EC2 Auto Scaling group that has mixed instance types.
     */
    public val mixedInstanceTypes: List<String>? = builder.mixedInstanceTypes
    /**
     * Describes whether the EC2 Auto Scaling group has a single instance type or a mixed instance type configuration.
     */
    public val type: aws.sdk.kotlin.services.computeoptimizer.model.AsgType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroupConfiguration(")
        append("allocationStrategy=$allocationStrategy,")
        append("desiredCapacity=$desiredCapacity,")
        append("estimatedInstanceHourReductionPercentage=$estimatedInstanceHourReductionPercentage,")
        append("instanceType=$instanceType,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("mixedInstanceTypes=$mixedInstanceTypes,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (desiredCapacity)
        result = 31 * result + (estimatedInstanceHourReductionPercentage?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (maxSize)
        result = 31 * result + (minSize)
        result = 31 * result + (mixedInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroupConfiguration

        if (allocationStrategy != other.allocationStrategy) return false
        if (desiredCapacity != other.desiredCapacity) return false
        if (!(estimatedInstanceHourReductionPercentage?.equals(other.estimatedInstanceHourReductionPercentage) ?: (other.estimatedInstanceHourReductionPercentage == null))) return false
        if (instanceType != other.instanceType) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (mixedInstanceTypes != other.mixedInstanceTypes) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the allocation strategy that the EC2 Auto Scaling group uses. This field is only available for EC2 Auto Scaling groups with mixed instance types.
         */
        public var allocationStrategy: aws.sdk.kotlin.services.computeoptimizer.model.AllocationStrategy? = null
        /**
         * The desired capacity, or number of instances, for the EC2 Auto Scaling group.
         */
        public var desiredCapacity: kotlin.Int = 0
        /**
         * Describes the projected percentage reduction in instance hours after adopting the recommended configuration. This field is only available for EC2 Auto Scaling groups with scaling policies.
         */
        public var estimatedInstanceHourReductionPercentage: kotlin.Double? = null
        /**
         * The instance type for the EC2 Auto Scaling group.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The maximum size, or maximum number of instances, for the EC2 Auto Scaling group.
         */
        public var maxSize: kotlin.Int = 0
        /**
         * The minimum size, or minimum number of instances, for the EC2 Auto Scaling group.
         */
        public var minSize: kotlin.Int = 0
        /**
         * List the instance types within an EC2 Auto Scaling group that has mixed instance types.
         */
        public var mixedInstanceTypes: List<String>? = null
        /**
         * Describes whether the EC2 Auto Scaling group has a single instance type or a mixed instance type configuration.
         */
        public var type: aws.sdk.kotlin.services.computeoptimizer.model.AsgType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.desiredCapacity = x.desiredCapacity
            this.estimatedInstanceHourReductionPercentage = x.estimatedInstanceHourReductionPercentage
            this.instanceType = x.instanceType
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.mixedInstanceTypes = x.mixedInstanceTypes
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupConfiguration = AutoScalingGroupConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
