// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.computeoptimizer.auth.ComputeOptimizerAuthSchemeProvider
import aws.sdk.kotlin.services.computeoptimizer.auth.DefaultComputeOptimizerAuthSchemeProvider
import aws.sdk.kotlin.services.computeoptimizer.endpoints.ComputeOptimizerEndpointParameters
import aws.sdk.kotlin.services.computeoptimizer.endpoints.ComputeOptimizerEndpointProvider
import aws.sdk.kotlin.services.computeoptimizer.endpoints.DefaultComputeOptimizerEndpointProvider
import aws.sdk.kotlin.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.DeleteRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEcsServiceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEcsServiceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportIdleRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportIdleRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportLicenseRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportLicenseRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.ExportRdsDatabaseRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.ExportRdsDatabaseRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetIdleRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetIdleRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetLicenseRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetLicenseRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationProjectedMetricsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationProjectedMetricsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationsRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRdsDatabaseRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.GetRecommendationSummariesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesRequest
import aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesResponse
import aws.sdk.kotlin.services.computeoptimizer.model.UpdateEnrollmentStatusRequest
import aws.sdk.kotlin.services.computeoptimizer.model.UpdateEnrollmentStatusResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Compute Optimizer"
public const val SdkVersion: String = "1.5.6"
public const val ServiceApiVersion: String = "2019-11-01"

/**
 * Compute Optimizer is a service that analyzes the configuration and utilization metrics of your Amazon Web Services compute resources, such as Amazon EC2 instances, Amazon EC2 Auto Scaling groups, Lambda functions, Amazon EBS volumes, and Amazon ECS services on Fargate. It reports whether your resources are optimal, and generates optimization recommendations to reduce the cost and improve the performance of your workloads. Compute Optimizer also provides recent utilization metric data, in addition to projected utilization metric data for the recommendations, which you can use to evaluate which recommendation provides the best price-performance trade-off. The analysis of your usage patterns can help you decide when to move or resize your running resources, and still meet your performance and capacity requirements. For more information about Compute Optimizer, including the required permissions to use the service, see the [Compute Optimizer User Guide](https://docs.aws.amazon.com/compute-optimizer/latest/ug/).
 */
public interface ComputeOptimizerClient : SdkClient {
    /**
     * ComputeOptimizerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ComputeOptimizerClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ComputeOptimizer",
                "COMPUTE_OPTIMIZER",
                "compute_optimizer",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ComputeOptimizerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ComputeOptimizerClient = DefaultComputeOptimizerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ComputeOptimizerEndpointProvider = builder.endpointProvider ?: DefaultComputeOptimizerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ComputeOptimizerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultComputeOptimizerAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Compute Optimizer"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ComputeOptimizerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ComputeOptimizerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes a recommendation preference, such as enhanced infrastructure metrics.
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun deleteRecommendationPreferences(input: DeleteRecommendationPreferencesRequest): DeleteRecommendationPreferencesResponse

    /**
     * Describes recommendation export jobs created in the last seven days.
     *
     * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs action to view your export jobs.
     */
    public suspend fun describeRecommendationExportJobs(input: DescribeRecommendationExportJobsRequest = DescribeRecommendationExportJobsRequest { }): DescribeRecommendationExportJobsResponse

    /**
     * Exports optimization recommendations for Auto Scaling groups.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportAutoScalingGroupRecommendations(input: ExportAutoScalingGroupRecommendationsRequest): ExportAutoScalingGroupRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon EBS volumes.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportEbsVolumeRecommendations(input: ExportEbsVolumeRecommendationsRequest): ExportEbsVolumeRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon EC2 instances.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportEc2InstanceRecommendations(input: ExportEc2InstanceRecommendationsRequest): ExportEc2InstanceRecommendationsResponse

    /**
     * Exports optimization recommendations for Amazon ECS services on Fargate.
     *
     * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportEcsServiceRecommendations(input: ExportEcsServiceRecommendationsRequest): ExportEcsServiceRecommendationsResponse

    /**
     * Export optimization recommendations for your idle resources.
     *
     * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one idle resource export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportIdleRecommendations(input: ExportIdleRecommendationsRequest): ExportIdleRecommendationsResponse

    /**
     * Exports optimization recommendations for Lambda functions.
     *
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportLambdaFunctionRecommendations(input: ExportLambdaFunctionRecommendationsRequest): ExportLambdaFunctionRecommendationsResponse

    /**
     * Export optimization recommendations for your licenses.
     *
     * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one license export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportLicenseRecommendations(input: ExportLicenseRecommendationsRequest): ExportLicenseRecommendationsResponse

    /**
     * Export optimization recommendations for your Amazon Aurora and Amazon Relational Database Service (Amazon RDS) databases.
     *
     * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
     *
     * You can have only one Amazon Aurora or RDS export job in progress per Amazon Web Services Region.
     */
    public suspend fun exportRdsDatabaseRecommendations(input: ExportRdsDatabaseRecommendationsRequest): ExportRdsDatabaseRecommendationsResponse

    /**
     * Returns Auto Scaling group recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getAutoScalingGroupRecommendations(input: GetAutoScalingGroupRecommendationsRequest = GetAutoScalingGroupRecommendationsRequest { }): GetAutoScalingGroupRecommendationsResponse

    /**
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getEbsVolumeRecommendations(input: GetEbsVolumeRecommendationsRequest = GetEbsVolumeRecommendationsRequest { }): GetEbsVolumeRecommendationsResponse

    /**
     * Returns Amazon EC2 instance recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getEc2InstanceRecommendations(input: GetEc2InstanceRecommendationsRequest = GetEc2InstanceRecommendationsRequest { }): GetEc2InstanceRecommendationsResponse

    /**
     * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
     *
     * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned when you run this action. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
     */
    public suspend fun getEc2RecommendationProjectedMetrics(input: GetEc2RecommendationProjectedMetricsRequest): GetEc2RecommendationProjectedMetricsResponse

    /**
     * Returns the projected metrics of Amazon ECS service recommendations.
     */
    public suspend fun getEcsServiceRecommendationProjectedMetrics(input: GetEcsServiceRecommendationProjectedMetricsRequest): GetEcsServiceRecommendationProjectedMetricsResponse

    /**
     * Returns Amazon ECS service recommendations.
     *
     *  Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getEcsServiceRecommendations(input: GetEcsServiceRecommendationsRequest = GetEcsServiceRecommendationsRequest { }): GetEcsServiceRecommendationsResponse

    /**
     * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure metrics. Considers all applicable preferences that you might have set at the resource, account, and organization level.
     *
     * When you create a recommendation preference, you can set its status to `Active` or `Inactive`. Use this action to view the recommendation preferences that are in effect, or `Active`.
     */
    public suspend fun getEffectiveRecommendationPreferences(input: GetEffectiveRecommendationPreferencesRequest): GetEffectiveRecommendationPreferencesResponse

    /**
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
     *
     * If the account is the management account of an organization, this action also confirms the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information about the enrollment status of member accounts of an organization.
     */
    public suspend fun getEnrollmentStatus(input: GetEnrollmentStatusRequest = GetEnrollmentStatusRequest { }): GetEnrollmentStatusResponse

    /**
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.
     *
     * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
     */
    public suspend fun getEnrollmentStatusesForOrganization(input: GetEnrollmentStatusesForOrganizationRequest = GetEnrollmentStatusesForOrganizationRequest { }): GetEnrollmentStatusesForOrganizationResponse

    /**
     * Returns idle resource recommendations. Compute Optimizer generates recommendations for idle resources that meet a specific set of requirements. For more information, see [Resource requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*
     */
    public suspend fun getIdleRecommendations(input: GetIdleRecommendationsRequest = GetIdleRecommendationsRequest { }): GetIdleRecommendationsResponse

    /**
     * Returns Lambda function recommendations.
     *
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getLambdaFunctionRecommendations(input: GetLambdaFunctionRecommendationsRequest = GetLambdaFunctionRecommendationsRequest { }): GetLambdaFunctionRecommendationsResponse

    /**
     * Returns license recommendations for Amazon EC2 instances that run on a specific license.
     *
     * Compute Optimizer generates recommendations for licenses that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getLicenseRecommendations(input: GetLicenseRecommendationsRequest = GetLicenseRecommendationsRequest { }): GetLicenseRecommendationsResponse

    /**
     * Returns the projected metrics of Aurora and RDS database recommendations.
     */
    public suspend fun getRdsDatabaseRecommendationProjectedMetrics(input: GetRdsDatabaseRecommendationProjectedMetricsRequest): GetRdsDatabaseRecommendationProjectedMetricsResponse

    /**
     * Returns Amazon Aurora and RDS database recommendations.
     *
     * Compute Optimizer generates recommendations for Amazon Aurora and RDS databases that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getRdsDatabaseRecommendations(input: GetRdsDatabaseRecommendationsRequest = GetRdsDatabaseRecommendationsRequest { }): GetRdsDatabaseRecommendationsResponse

    /**
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     *
     * Use the `scope` parameter to specify which preferences to return. You can specify to return preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon Resource Name (ARN).
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun getRecommendationPreferences(input: GetRecommendationPreferencesRequest): GetRecommendationPreferencesResponse

    /**
     * Returns the optimization findings for an account.
     *
     * It returns the number of:
     * + Amazon EC2 instances in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
     * + EC2Auto Scaling groups in an account that are `NotOptimized`, or `Optimized`.
     * + Amazon EBS volumes in an account that are `NotOptimized`, or `Optimized`.
     * + Lambda functions in an account that are `NotOptimized`, or `Optimized`.
     * + Amazon ECS services in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
     * + Commercial software licenses in an account that are `InsufficientMetrics`, `NotOptimized` or `Optimized`.
     * + Amazon Aurora and Amazon RDS databases in an account that are `Underprovisioned`, `Overprovisioned`, `Optimized`, or `NotOptimized`.
     */
    public suspend fun getRecommendationSummaries(input: GetRecommendationSummariesRequest = GetRecommendationSummariesRequest { }): GetRecommendationSummariesResponse

    /**
     * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced infrastructure metrics.
     *
     * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun putRecommendationPreferences(input: PutRecommendationPreferencesRequest): PutRecommendationPreferencesResponse

    /**
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     *
     * If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.
     *
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see [Controlling access with Amazon Web Services Identity and Access Management](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html) in the *Compute Optimizer User Guide*.
     *
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its data. For more information, see [Using Service-Linked Roles for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html) in the *Compute Optimizer User Guide*.
     */
    public suspend fun updateEnrollmentStatus(input: UpdateEnrollmentStatusRequest): UpdateEnrollmentStatusResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ComputeOptimizerClient.withConfig(block: ComputeOptimizerClient.Config.Builder.() -> Unit): ComputeOptimizerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultComputeOptimizerClient(newConfig)
}

/**
 * Deletes a recommendation preference, such as enhanced infrastructure metrics.
 *
 * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.deleteRecommendationPreferences(crossinline block: DeleteRecommendationPreferencesRequest.Builder.() -> Unit): DeleteRecommendationPreferencesResponse = deleteRecommendationPreferences(DeleteRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Describes recommendation export jobs created in the last seven days.
 *
 * Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs action to view your export jobs.
 */
public suspend inline fun ComputeOptimizerClient.describeRecommendationExportJobs(crossinline block: DescribeRecommendationExportJobsRequest.Builder.() -> Unit): DescribeRecommendationExportJobsResponse = describeRecommendationExportJobs(DescribeRecommendationExportJobsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Auto Scaling groups.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportAutoScalingGroupRecommendations(crossinline block: ExportAutoScalingGroupRecommendationsRequest.Builder.() -> Unit): ExportAutoScalingGroupRecommendationsResponse = exportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Amazon EBS volumes.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportEbsVolumeRecommendations(crossinline block: ExportEbsVolumeRecommendationsRequest.Builder.() -> Unit): ExportEbsVolumeRecommendationsResponse = exportEbsVolumeRecommendations(ExportEbsVolumeRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Amazon EC2 instances.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportEc2InstanceRecommendations(crossinline block: ExportEc2InstanceRecommendationsRequest.Builder.() -> Unit): ExportEc2InstanceRecommendationsResponse = exportEc2InstanceRecommendations(ExportEc2InstanceRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Amazon ECS services on Fargate.
 *
 * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportEcsServiceRecommendations(crossinline block: ExportEcsServiceRecommendationsRequest.Builder.() -> Unit): ExportEcsServiceRecommendationsResponse = exportEcsServiceRecommendations(ExportEcsServiceRecommendationsRequest.Builder().apply(block).build())

/**
 * Export optimization recommendations for your idle resources.
 *
 * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one idle resource export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportIdleRecommendations(crossinline block: ExportIdleRecommendationsRequest.Builder.() -> Unit): ExportIdleRecommendationsResponse = exportIdleRecommendations(ExportIdleRecommendationsRequest.Builder().apply(block).build())

/**
 * Exports optimization recommendations for Lambda functions.
 *
 * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Lambda function export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportLambdaFunctionRecommendations(crossinline block: ExportLambdaFunctionRecommendationsRequest.Builder.() -> Unit): ExportLambdaFunctionRecommendationsResponse = exportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest.Builder().apply(block).build())

/**
 * Export optimization recommendations for your licenses.
 *
 * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one license export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportLicenseRecommendations(crossinline block: ExportLicenseRecommendationsRequest.Builder.() -> Unit): ExportLicenseRecommendationsResponse = exportLicenseRecommendations(ExportLicenseRecommendationsRequest.Builder().apply(block).build())

/**
 * Export optimization recommendations for your Amazon Aurora and Amazon Relational Database Service (Amazon RDS) databases.
 *
 * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see [Exporting Recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html) in the *Compute Optimizer User Guide*.
 *
 * You can have only one Amazon Aurora or RDS export job in progress per Amazon Web Services Region.
 */
public suspend inline fun ComputeOptimizerClient.exportRdsDatabaseRecommendations(crossinline block: ExportRdsDatabaseRecommendationsRequest.Builder.() -> Unit): ExportRdsDatabaseRecommendationsResponse = exportRdsDatabaseRecommendations(ExportRdsDatabaseRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns Auto Scaling group recommendations.
 *
 * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getAutoScalingGroupRecommendations(crossinline block: GetAutoScalingGroupRecommendationsRequest.Builder.() -> Unit): GetAutoScalingGroupRecommendationsResponse = getAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
 *
 * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getEbsVolumeRecommendations(crossinline block: GetEbsVolumeRecommendationsRequest.Builder.() -> Unit): GetEbsVolumeRecommendationsResponse = getEbsVolumeRecommendations(GetEbsVolumeRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns Amazon EC2 instance recommendations.
 *
 * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getEc2InstanceRecommendations(crossinline block: GetEc2InstanceRecommendationsRequest.Builder.() -> Unit): GetEc2InstanceRecommendationsResponse = getEc2InstanceRecommendations(GetEc2InstanceRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
 *
 * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned when you run this action. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
 */
public suspend inline fun ComputeOptimizerClient.getEc2RecommendationProjectedMetrics(crossinline block: GetEc2RecommendationProjectedMetricsRequest.Builder.() -> Unit): GetEc2RecommendationProjectedMetricsResponse = getEc2RecommendationProjectedMetrics(GetEc2RecommendationProjectedMetricsRequest.Builder().apply(block).build())

/**
 * Returns the projected metrics of Amazon ECS service recommendations.
 */
public suspend inline fun ComputeOptimizerClient.getEcsServiceRecommendationProjectedMetrics(crossinline block: GetEcsServiceRecommendationProjectedMetricsRequest.Builder.() -> Unit): GetEcsServiceRecommendationProjectedMetricsResponse = getEcsServiceRecommendationProjectedMetrics(GetEcsServiceRecommendationProjectedMetricsRequest.Builder().apply(block).build())

/**
 * Returns Amazon ECS service recommendations.
 *
 *  Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getEcsServiceRecommendations(crossinline block: GetEcsServiceRecommendationsRequest.Builder.() -> Unit): GetEcsServiceRecommendationsResponse = getEcsServiceRecommendations(GetEcsServiceRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure metrics. Considers all applicable preferences that you might have set at the resource, account, and organization level.
 *
 * When you create a recommendation preference, you can set its status to `Active` or `Inactive`. Use this action to view the recommendation preferences that are in effect, or `Active`.
 */
public suspend inline fun ComputeOptimizerClient.getEffectiveRecommendationPreferences(crossinline block: GetEffectiveRecommendationPreferencesRequest.Builder.() -> Unit): GetEffectiveRecommendationPreferencesResponse = getEffectiveRecommendationPreferences(GetEffectiveRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
 *
 * If the account is the management account of an organization, this action also confirms the enrollment status of member accounts of the organization. Use the GetEnrollmentStatusesForOrganization action to get detailed information about the enrollment status of member accounts of an organization.
 */
public suspend inline fun ComputeOptimizerClient.getEnrollmentStatus(crossinline block: GetEnrollmentStatusRequest.Builder.() -> Unit): GetEnrollmentStatusResponse = getEnrollmentStatus(GetEnrollmentStatusRequest.Builder().apply(block).build())

/**
 * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.
 *
 * To get the enrollment status of standalone accounts, use the GetEnrollmentStatus action.
 */
public suspend inline fun ComputeOptimizerClient.getEnrollmentStatusesForOrganization(crossinline block: GetEnrollmentStatusesForOrganizationRequest.Builder.() -> Unit): GetEnrollmentStatusesForOrganizationResponse = getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationRequest.Builder().apply(block).build())

/**
 * Returns idle resource recommendations. Compute Optimizer generates recommendations for idle resources that meet a specific set of requirements. For more information, see [Resource requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*
 */
public suspend inline fun ComputeOptimizerClient.getIdleRecommendations(crossinline block: GetIdleRecommendationsRequest.Builder.() -> Unit): GetIdleRecommendationsResponse = getIdleRecommendations(GetIdleRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns Lambda function recommendations.
 *
 * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getLambdaFunctionRecommendations(crossinline block: GetLambdaFunctionRecommendationsRequest.Builder.() -> Unit): GetLambdaFunctionRecommendationsResponse = getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns license recommendations for Amazon EC2 instances that run on a specific license.
 *
 * Compute Optimizer generates recommendations for licenses that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getLicenseRecommendations(crossinline block: GetLicenseRecommendationsRequest.Builder.() -> Unit): GetLicenseRecommendationsResponse = getLicenseRecommendations(GetLicenseRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns the projected metrics of Aurora and RDS database recommendations.
 */
public suspend inline fun ComputeOptimizerClient.getRdsDatabaseRecommendationProjectedMetrics(crossinline block: GetRdsDatabaseRecommendationProjectedMetricsRequest.Builder.() -> Unit): GetRdsDatabaseRecommendationProjectedMetricsResponse = getRdsDatabaseRecommendationProjectedMetrics(GetRdsDatabaseRecommendationProjectedMetricsRequest.Builder().apply(block).build())

/**
 * Returns Amazon Aurora and RDS database recommendations.
 *
 * Compute Optimizer generates recommendations for Amazon Aurora and RDS databases that meet a specific set of requirements. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getRdsDatabaseRecommendations(crossinline block: GetRdsDatabaseRecommendationsRequest.Builder.() -> Unit): GetRdsDatabaseRecommendationsResponse = getRdsDatabaseRecommendations(GetRdsDatabaseRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
 *
 * Use the `scope` parameter to specify which preferences to return. You can specify to return preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon Resource Name (ARN).
 *
 * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.getRecommendationPreferences(crossinline block: GetRecommendationPreferencesRequest.Builder.() -> Unit): GetRecommendationPreferencesResponse = getRecommendationPreferences(GetRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Returns the optimization findings for an account.
 *
 * It returns the number of:
 * + Amazon EC2 instances in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
 * + EC2Auto Scaling groups in an account that are `NotOptimized`, or `Optimized`.
 * + Amazon EBS volumes in an account that are `NotOptimized`, or `Optimized`.
 * + Lambda functions in an account that are `NotOptimized`, or `Optimized`.
 * + Amazon ECS services in an account that are `Underprovisioned`, `Overprovisioned`, or `Optimized`.
 * + Commercial software licenses in an account that are `InsufficientMetrics`, `NotOptimized` or `Optimized`.
 * + Amazon Aurora and Amazon RDS databases in an account that are `Underprovisioned`, `Overprovisioned`, `Optimized`, or `NotOptimized`.
 */
public suspend inline fun ComputeOptimizerClient.getRecommendationSummaries(crossinline block: GetRecommendationSummariesRequest.Builder.() -> Unit): GetRecommendationSummariesResponse = getRecommendationSummaries(GetRecommendationSummariesRequest.Builder().apply(block).build())

/**
 * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced infrastructure metrics.
 *
 * For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.putRecommendationPreferences(crossinline block: PutRecommendationPreferencesRequest.Builder.() -> Unit): PutRecommendationPreferencesResponse = putRecommendationPreferences(PutRecommendationPreferencesRequest.Builder().apply(block).build())

/**
 * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
 *
 * If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.
 *
 * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see [Controlling access with Amazon Web Services Identity and Access Management](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html) in the *Compute Optimizer User Guide*.
 *
 * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its data. For more information, see [Using Service-Linked Roles for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html) in the *Compute Optimizer User Guide*.
 */
public suspend inline fun ComputeOptimizerClient.updateEnrollmentStatus(crossinline block: UpdateEnrollmentStatusRequest.Builder.() -> Unit): UpdateEnrollmentStatusResponse = updateEnrollmentStatus(UpdateEnrollmentStatusRequest.Builder().apply(block).build())
