// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A summary of a recommendation.
 */
public class RecommendationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the recommendation summary.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
     *
     * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
     *
     * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
     */
    public val aggregatedSavingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.aggregatedSavingsOpportunity
    /**
     * An object that describes the performance risk ratings for a given resource type.
     */
    public val currentPerformanceRiskRatings: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings? = builder.currentPerformanceRiskRatings
    /**
     * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
     *
     * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
     *
     * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
     */
    public val idleSavingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.idleSavingsOpportunity
    /**
     * Describes the findings summary of the idle resources.
     */
    public val idleSummaries: List<IdleSummary>? = builder.idleSummaries
    /**
     * An array of objects that describes the estimated monthly saving amounts for the instances running on the specified `inferredWorkloadTypes`. The array contains the top five savings opportunites for the instances that run inferred workload types.
     */
    public val inferredWorkloadSavings: List<InferredWorkloadSaving>? = builder.inferredWorkloadSavings
    /**
     * The resource type that the recommendation summary applies to.
     */
    public val recommendationResourceType: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSourceType? = builder.recommendationResourceType
    /**
     * An object that describes the savings opportunity for a given resource type. Savings opportunity includes the estimated monthly savings amount and percentage.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity
    /**
     * An array of objects that describe a recommendation summary.
     */
    public val summaries: List<Summary>? = builder.summaries

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationSummary(")
        append("accountId=$accountId,")
        append("aggregatedSavingsOpportunity=$aggregatedSavingsOpportunity,")
        append("currentPerformanceRiskRatings=$currentPerformanceRiskRatings,")
        append("idleSavingsOpportunity=$idleSavingsOpportunity,")
        append("idleSummaries=$idleSummaries,")
        append("inferredWorkloadSavings=$inferredWorkloadSavings,")
        append("recommendationResourceType=$recommendationResourceType,")
        append("savingsOpportunity=$savingsOpportunity,")
        append("summaries=$summaries")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (aggregatedSavingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (currentPerformanceRiskRatings?.hashCode() ?: 0)
        result = 31 * result + (idleSavingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (idleSummaries?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadSavings?.hashCode() ?: 0)
        result = 31 * result + (recommendationResourceType?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (summaries?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationSummary

        if (accountId != other.accountId) return false
        if (aggregatedSavingsOpportunity != other.aggregatedSavingsOpportunity) return false
        if (currentPerformanceRiskRatings != other.currentPerformanceRiskRatings) return false
        if (idleSavingsOpportunity != other.idleSavingsOpportunity) return false
        if (idleSummaries != other.idleSummaries) return false
        if (inferredWorkloadSavings != other.inferredWorkloadSavings) return false
        if (recommendationResourceType != other.recommendationResourceType) return false
        if (savingsOpportunity != other.savingsOpportunity) return false
        if (summaries != other.summaries) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the recommendation summary.
         */
        public var accountId: kotlin.String? = null
        /**
         * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
         *
         * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
         *
         * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
         */
        public var aggregatedSavingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * An object that describes the performance risk ratings for a given resource type.
         */
        public var currentPerformanceRiskRatings: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings? = null
        /**
         * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
         *
         * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
         *
         * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
         */
        public var idleSavingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * Describes the findings summary of the idle resources.
         */
        public var idleSummaries: List<IdleSummary>? = null
        /**
         * An array of objects that describes the estimated monthly saving amounts for the instances running on the specified `inferredWorkloadTypes`. The array contains the top five savings opportunites for the instances that run inferred workload types.
         */
        public var inferredWorkloadSavings: List<InferredWorkloadSaving>? = null
        /**
         * The resource type that the recommendation summary applies to.
         */
        public var recommendationResourceType: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSourceType? = null
        /**
         * An object that describes the savings opportunity for a given resource type. Savings opportunity includes the estimated monthly savings amount and percentage.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * An array of objects that describe a recommendation summary.
         */
        public var summaries: List<Summary>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary) : this() {
            this.accountId = x.accountId
            this.aggregatedSavingsOpportunity = x.aggregatedSavingsOpportunity
            this.currentPerformanceRiskRatings = x.currentPerformanceRiskRatings
            this.idleSavingsOpportunity = x.idleSavingsOpportunity
            this.idleSummaries = x.idleSummaries
            this.inferredWorkloadSavings = x.inferredWorkloadSavings
            this.recommendationResourceType = x.recommendationResourceType
            this.savingsOpportunity = x.savingsOpportunity
            this.summaries = x.summaries
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary = RecommendationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun aggregatedSavingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.aggregatedSavingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings] inside the given [block]
         */
        public fun currentPerformanceRiskRatings(block: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings.Builder.() -> kotlin.Unit) {
            this.currentPerformanceRiskRatings = aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun idleSavingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.idleSavingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
