// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Aurora and RDS database recommendation.
 */
public class RdsdbRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the Amazon Aurora or RDS database.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The DB instance class of the current Aurora or RDS DB instance.
     */
    public val currentDbInstanceClass: kotlin.String? = builder.currentDbInstanceClass
    /**
     * The performance risk for the current DB instance.
     */
    public val currentInstancePerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.RdsCurrentInstancePerformanceRisk? = builder.currentInstancePerformanceRisk
    /**
     * The configuration of the current DB storage.
     */
    public val currentStorageConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration? = builder.currentStorageConfiguration
    /**
     * The level of variation in monthly I/O costs for the current DB storage configuration.
     */
    public val currentStorageEstimatedMonthlyVolumeIopsCostVariation: aws.sdk.kotlin.services.computeoptimizer.model.RdsEstimatedMonthlyVolumeIopsCostVariation? = builder.currentStorageEstimatedMonthlyVolumeIopsCostVariation
    /**
     * The identifier for DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * Describes the effective recommendation preferences for DB instances.
     */
    public val effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences? = builder.effectiveRecommendationPreferences
    /**
     * The engine of the DB instance.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * This indicates if the DB instance is idle or not.
     */
    public val idle: aws.sdk.kotlin.services.computeoptimizer.model.Idle? = builder.idle
    /**
     * The finding classification of an Amazon Aurora and RDS DB instance.
     *
     * For more information about finding classifications, see [ Finding classifications for Aurora and RDS databases](https://docs.aws.amazon.com/compute-optimizer/latest/ug/view-rds-recommendations.html#rds-recommendations-findings) in the *Compute Optimizer User Guide*.
     */
    public val instanceFinding: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceFinding? = builder.instanceFinding
    /**
     * The reason for the finding classification of a DB instance.
     */
    public val instanceFindingReasonCodes: List<RdsInstanceFindingReasonCode>? = builder.instanceFindingReasonCodes
    /**
     * An array of objects that describe the recommendation options for the RDS DB instance.
     */
    public val instanceRecommendationOptions: List<RdsdbInstanceRecommendationOption>? = builder.instanceRecommendationOptions
    /**
     * The timestamp of when the DB instance recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days the DB instance utilization metrics were analyzed.
     */
    public val lookbackPeriodInDays: kotlin.Double = builder.lookbackPeriodInDays
    /**
     * The promotion tier for the Aurora instance.
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * The ARN of the current Amazon Aurora or RDS database.
     *
     *  The following is the format of the ARN:
     *
     * `arn:aws:rds:{region}:{accountId}:db:{resourceName}`
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The finding classification of Amazon RDS DB instance storage.
     *
     * For more information about finding classifications, see [ Finding classifications for Aurora and RDS databases](https://docs.aws.amazon.com/compute-optimizer/latest/ug/view-rds-recommendations.html#rds-recommendations-findings) in the *Compute Optimizer User Guide*.
     */
    public val storageFinding: aws.sdk.kotlin.services.computeoptimizer.model.RdsStorageFinding? = builder.storageFinding
    /**
     * The reason for the finding classification of RDS DB instance storage.
     */
    public val storageFindingReasonCodes: List<RdsStorageFindingReasonCode>? = builder.storageFindingReasonCodes
    /**
     * An array of objects that describe the recommendation options for DB instance storage.
     */
    public val storageRecommendationOptions: List<RdsdbStorageRecommendationOption>? = builder.storageRecommendationOptions
    /**
     * A list of tags assigned to your DB instance recommendations.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An array of objects that describe the utilization metrics of the DB instance.
     */
    public val utilizationMetrics: List<RdsdbUtilizationMetric>? = builder.utilizationMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsdbRecommendation(")
        append("accountId=$accountId,")
        append("currentDbInstanceClass=$currentDbInstanceClass,")
        append("currentInstancePerformanceRisk=$currentInstancePerformanceRisk,")
        append("currentStorageConfiguration=$currentStorageConfiguration,")
        append("currentStorageEstimatedMonthlyVolumeIopsCostVariation=$currentStorageEstimatedMonthlyVolumeIopsCostVariation,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("effectiveRecommendationPreferences=$effectiveRecommendationPreferences,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("idle=$idle,")
        append("instanceFinding=$instanceFinding,")
        append("instanceFindingReasonCodes=$instanceFindingReasonCodes,")
        append("instanceRecommendationOptions=$instanceRecommendationOptions,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("promotionTier=$promotionTier,")
        append("resourceArn=$resourceArn,")
        append("storageFinding=$storageFinding,")
        append("storageFindingReasonCodes=$storageFindingReasonCodes,")
        append("storageRecommendationOptions=$storageRecommendationOptions,")
        append("tags=$tags,")
        append("utilizationMetrics=$utilizationMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentDbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (currentInstancePerformanceRisk?.hashCode() ?: 0)
        result = 31 * result + (currentStorageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (currentStorageEstimatedMonthlyVolumeIopsCostVariation?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (effectiveRecommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (idle?.hashCode() ?: 0)
        result = 31 * result + (instanceFinding?.hashCode() ?: 0)
        result = 31 * result + (instanceFindingReasonCodes?.hashCode() ?: 0)
        result = 31 * result + (instanceRecommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookbackPeriodInDays.hashCode())
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (storageFinding?.hashCode() ?: 0)
        result = 31 * result + (storageFindingReasonCodes?.hashCode() ?: 0)
        result = 31 * result + (storageRecommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsdbRecommendation

        if (accountId != other.accountId) return false
        if (currentDbInstanceClass != other.currentDbInstanceClass) return false
        if (currentInstancePerformanceRisk != other.currentInstancePerformanceRisk) return false
        if (currentStorageConfiguration != other.currentStorageConfiguration) return false
        if (currentStorageEstimatedMonthlyVolumeIopsCostVariation != other.currentStorageEstimatedMonthlyVolumeIopsCostVariation) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (effectiveRecommendationPreferences != other.effectiveRecommendationPreferences) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (idle != other.idle) return false
        if (instanceFinding != other.instanceFinding) return false
        if (instanceFindingReasonCodes != other.instanceFindingReasonCodes) return false
        if (instanceRecommendationOptions != other.instanceRecommendationOptions) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (!(lookbackPeriodInDays?.equals(other.lookbackPeriodInDays) ?: (other.lookbackPeriodInDays == null))) return false
        if (promotionTier != other.promotionTier) return false
        if (resourceArn != other.resourceArn) return false
        if (storageFinding != other.storageFinding) return false
        if (storageFindingReasonCodes != other.storageFindingReasonCodes) return false
        if (storageRecommendationOptions != other.storageRecommendationOptions) return false
        if (tags != other.tags) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the Amazon Aurora or RDS database.
         */
        public var accountId: kotlin.String? = null
        /**
         * The DB instance class of the current Aurora or RDS DB instance.
         */
        public var currentDbInstanceClass: kotlin.String? = null
        /**
         * The performance risk for the current DB instance.
         */
        public var currentInstancePerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.RdsCurrentInstancePerformanceRisk? = null
        /**
         * The configuration of the current DB storage.
         */
        public var currentStorageConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration? = null
        /**
         * The level of variation in monthly I/O costs for the current DB storage configuration.
         */
        public var currentStorageEstimatedMonthlyVolumeIopsCostVariation: aws.sdk.kotlin.services.computeoptimizer.model.RdsEstimatedMonthlyVolumeIopsCostVariation? = null
        /**
         * The identifier for DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * Describes the effective recommendation preferences for DB instances.
         */
        public var effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences? = null
        /**
         * The engine of the DB instance.
         */
        public var engine: kotlin.String? = null
        /**
         * The database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * This indicates if the DB instance is idle or not.
         */
        public var idle: aws.sdk.kotlin.services.computeoptimizer.model.Idle? = null
        /**
         * The finding classification of an Amazon Aurora and RDS DB instance.
         *
         * For more information about finding classifications, see [ Finding classifications for Aurora and RDS databases](https://docs.aws.amazon.com/compute-optimizer/latest/ug/view-rds-recommendations.html#rds-recommendations-findings) in the *Compute Optimizer User Guide*.
         */
        public var instanceFinding: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceFinding? = null
        /**
         * The reason for the finding classification of a DB instance.
         */
        public var instanceFindingReasonCodes: List<RdsInstanceFindingReasonCode>? = null
        /**
         * An array of objects that describe the recommendation options for the RDS DB instance.
         */
        public var instanceRecommendationOptions: List<RdsdbInstanceRecommendationOption>? = null
        /**
         * The timestamp of when the DB instance recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days the DB instance utilization metrics were analyzed.
         */
        public var lookbackPeriodInDays: kotlin.Double = 0.0
        /**
         * The promotion tier for the Aurora instance.
         */
        public var promotionTier: kotlin.Int? = null
        /**
         * The ARN of the current Amazon Aurora or RDS database.
         *
         *  The following is the format of the ARN:
         *
         * `arn:aws:rds:{region}:{accountId}:db:{resourceName}`
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The finding classification of Amazon RDS DB instance storage.
         *
         * For more information about finding classifications, see [ Finding classifications for Aurora and RDS databases](https://docs.aws.amazon.com/compute-optimizer/latest/ug/view-rds-recommendations.html#rds-recommendations-findings) in the *Compute Optimizer User Guide*.
         */
        public var storageFinding: aws.sdk.kotlin.services.computeoptimizer.model.RdsStorageFinding? = null
        /**
         * The reason for the finding classification of RDS DB instance storage.
         */
        public var storageFindingReasonCodes: List<RdsStorageFindingReasonCode>? = null
        /**
         * An array of objects that describe the recommendation options for DB instance storage.
         */
        public var storageRecommendationOptions: List<RdsdbStorageRecommendationOption>? = null
        /**
         * A list of tags assigned to your DB instance recommendations.
         */
        public var tags: List<Tag>? = null
        /**
         * An array of objects that describe the utilization metrics of the DB instance.
         */
        public var utilizationMetrics: List<RdsdbUtilizationMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RdsdbRecommendation) : this() {
            this.accountId = x.accountId
            this.currentDbInstanceClass = x.currentDbInstanceClass
            this.currentInstancePerformanceRisk = x.currentInstancePerformanceRisk
            this.currentStorageConfiguration = x.currentStorageConfiguration
            this.currentStorageEstimatedMonthlyVolumeIopsCostVariation = x.currentStorageEstimatedMonthlyVolumeIopsCostVariation
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.effectiveRecommendationPreferences = x.effectiveRecommendationPreferences
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.idle = x.idle
            this.instanceFinding = x.instanceFinding
            this.instanceFindingReasonCodes = x.instanceFindingReasonCodes
            this.instanceRecommendationOptions = x.instanceRecommendationOptions
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.promotionTier = x.promotionTier
            this.resourceArn = x.resourceArn
            this.storageFinding = x.storageFinding
            this.storageFindingReasonCodes = x.storageFindingReasonCodes
            this.storageRecommendationOptions = x.storageRecommendationOptions
            this.tags = x.tags
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbRecommendation = RdsdbRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration] inside the given [block]
         */
        public fun currentStorageConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration.Builder.() -> kotlin.Unit) {
            this.currentStorageConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences] inside the given [block]
         */
        public fun effectiveRecommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.effectiveRecommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.RdsEffectiveRecommendationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
