// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the recommendation options for a DB instance.
 */
public class RdsdbInstanceRecommendationOption private constructor(builder: Builder) {
    /**
     * Describes the DB instance class recommendation option for your Amazon Aurora or RDS database.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The performance risk of the DB instance recommendation option.
     */
    public val performanceRisk: kotlin.Double = builder.performanceRisk
    /**
     * An array of objects that describe the projected utilization metrics of the DB instance recommendation option.
     */
    public val projectedUtilizationMetrics: List<RdsdbUtilizationMetric>? = builder.projectedUtilizationMetrics
    /**
     * The rank identifier of the DB instance recommendation option.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
     *
     * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
     *
     * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity
    /**
     * Describes the savings opportunity for Amazon Aurora and RDS database recommendations or for the recommendation option.
     *
     * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.
     */
    public val savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts? = builder.savingsOpportunityAfterDiscounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbInstanceRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsdbInstanceRecommendationOption(")
        append("dbInstanceClass=$dbInstanceClass,")
        append("performanceRisk=$performanceRisk,")
        append("projectedUtilizationMetrics=$projectedUtilizationMetrics,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity,")
        append("savingsOpportunityAfterDiscounts=$savingsOpportunityAfterDiscounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceClass?.hashCode() ?: 0
        result = 31 * result + (performanceRisk.hashCode())
        result = 31 * result + (projectedUtilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunityAfterDiscounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsdbInstanceRecommendationOption

        if (dbInstanceClass != other.dbInstanceClass) return false
        if (!(performanceRisk?.equals(other.performanceRisk) ?: (other.performanceRisk == null))) return false
        if (projectedUtilizationMetrics != other.projectedUtilizationMetrics) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false
        if (savingsOpportunityAfterDiscounts != other.savingsOpportunityAfterDiscounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbInstanceRecommendationOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the DB instance class recommendation option for your Amazon Aurora or RDS database.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The performance risk of the DB instance recommendation option.
         */
        public var performanceRisk: kotlin.Double = 0.0
        /**
         * An array of objects that describe the projected utilization metrics of the DB instance recommendation option.
         */
        public var projectedUtilizationMetrics: List<RdsdbUtilizationMetric>? = null
        /**
         * The rank identifier of the DB instance recommendation option.
         */
        public var rank: kotlin.Int = 0
        /**
         * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
         *
         * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
         *
         * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * Describes the savings opportunity for Amazon Aurora and RDS database recommendations or for the recommendation option.
         *
         * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.
         */
        public var savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RdsdbInstanceRecommendationOption) : this() {
            this.dbInstanceClass = x.dbInstanceClass
            this.performanceRisk = x.performanceRisk
            this.projectedUtilizationMetrics = x.projectedUtilizationMetrics
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
            this.savingsOpportunityAfterDiscounts = x.savingsOpportunityAfterDiscounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbInstanceRecommendationOption = RdsdbInstanceRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts] inside the given [block]
         */
        public fun savingsOpportunityAfterDiscounts(block: aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts.Builder.() -> kotlin.Unit) {
            this.savingsOpportunityAfterDiscounts = aws.sdk.kotlin.services.computeoptimizer.model.RdsInstanceSavingsOpportunityAfterDiscounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
