// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a license recommendation for an EC2 instance.
 */
public class LicenseRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the license.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * An object that describes the current configuration of an instance that runs on a license.
     */
    public val currentLicenseConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration? = builder.currentLicenseConfiguration
    /**
     * The finding classification for an instance that runs on a license.
     *
     * Findings include:
     * + `InsufficentMetrics` — When Compute Optimizer detects that your CloudWatch Application Insights isn't enabled or is enabled with insufficient permissions.
     * + `NotOptimized` — When Compute Optimizer detects that your EC2 infrastructure isn't using any of the SQL server license features you're paying for, a license is considered not optimized.
     * + `Optimized` — When Compute Optimizer detects that all specifications of your license meet the performance requirements of your workload.
     */
    public val finding: aws.sdk.kotlin.services.computeoptimizer.model.LicenseFinding? = builder.finding
    /**
     * The reason for the finding classification for an instance that runs on a license.
     *
     * Finding reason codes include:
     * + `Optimized` — All specifications of your license meet the performance requirements of your workload.
     * + `LicenseOverprovisioned` — A license is considered over-provisioned when your license can be downgraded while still meeting the performance requirements of your workload.
     * + `InvalidCloudwatchApplicationInsights` — CloudWatch Application Insights isn't configured properly.
     * + `CloudwatchApplicationInsightsError` — There is a CloudWatch Application Insights error.
     */
    public val findingReasonCodes: List<LicenseFindingReasonCode>? = builder.findingReasonCodes
    /**
     * The timestamp of when the license recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * An array of objects that describe the license recommendation options.
     */
    public val licenseRecommendationOptions: List<LicenseRecommendationOption>? = builder.licenseRecommendationOptions
    /**
     * The number of days for which utilization metrics were analyzed for an instance that runs on a license.
     */
    public val lookbackPeriodInDays: kotlin.Double = builder.lookbackPeriodInDays
    /**
     * The ARN that identifies the Amazon EC2 instance.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A list of tags assigned to an EC2 instance.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LicenseRecommendation(")
        append("accountId=$accountId,")
        append("currentLicenseConfiguration=$currentLicenseConfiguration,")
        append("finding=$finding,")
        append("findingReasonCodes=$findingReasonCodes,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("licenseRecommendationOptions=$licenseRecommendationOptions,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("resourceArn=$resourceArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentLicenseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (findingReasonCodes?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (licenseRecommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (lookbackPeriodInDays.hashCode())
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LicenseRecommendation

        if (accountId != other.accountId) return false
        if (currentLicenseConfiguration != other.currentLicenseConfiguration) return false
        if (finding != other.finding) return false
        if (findingReasonCodes != other.findingReasonCodes) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (licenseRecommendationOptions != other.licenseRecommendationOptions) return false
        if (!(lookbackPeriodInDays?.equals(other.lookbackPeriodInDays) ?: (other.lookbackPeriodInDays == null))) return false
        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the license.
         */
        public var accountId: kotlin.String? = null
        /**
         * An object that describes the current configuration of an instance that runs on a license.
         */
        public var currentLicenseConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration? = null
        /**
         * The finding classification for an instance that runs on a license.
         *
         * Findings include:
         * + `InsufficentMetrics` — When Compute Optimizer detects that your CloudWatch Application Insights isn't enabled or is enabled with insufficient permissions.
         * + `NotOptimized` — When Compute Optimizer detects that your EC2 infrastructure isn't using any of the SQL server license features you're paying for, a license is considered not optimized.
         * + `Optimized` — When Compute Optimizer detects that all specifications of your license meet the performance requirements of your workload.
         */
        public var finding: aws.sdk.kotlin.services.computeoptimizer.model.LicenseFinding? = null
        /**
         * The reason for the finding classification for an instance that runs on a license.
         *
         * Finding reason codes include:
         * + `Optimized` — All specifications of your license meet the performance requirements of your workload.
         * + `LicenseOverprovisioned` — A license is considered over-provisioned when your license can be downgraded while still meeting the performance requirements of your workload.
         * + `InvalidCloudwatchApplicationInsights` — CloudWatch Application Insights isn't configured properly.
         * + `CloudwatchApplicationInsightsError` — There is a CloudWatch Application Insights error.
         */
        public var findingReasonCodes: List<LicenseFindingReasonCode>? = null
        /**
         * The timestamp of when the license recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of objects that describe the license recommendation options.
         */
        public var licenseRecommendationOptions: List<LicenseRecommendationOption>? = null
        /**
         * The number of days for which utilization metrics were analyzed for an instance that runs on a license.
         */
        public var lookbackPeriodInDays: kotlin.Double = 0.0
        /**
         * The ARN that identifies the Amazon EC2 instance.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * A list of tags assigned to an EC2 instance.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendation) : this() {
            this.accountId = x.accountId
            this.currentLicenseConfiguration = x.currentLicenseConfiguration
            this.finding = x.finding
            this.findingReasonCodes = x.findingReasonCodes
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.licenseRecommendationOptions = x.licenseRecommendationOptions
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendation = LicenseRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration] inside the given [block]
         */
        public fun currentLicenseConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration.Builder.() -> kotlin.Unit) {
            this.currentLicenseConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
