// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration of a license for an Amazon EC2 instance.
 */
public class LicenseConfiguration private constructor(builder: Builder) {
    /**
     * The instance type used in the license.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The edition of the license for the application that runs on the instance.
     */
    public val licenseEdition: aws.sdk.kotlin.services.computeoptimizer.model.LicenseEdition? = builder.licenseEdition
    /**
     * The license type associated with the instance.
     */
    public val licenseModel: aws.sdk.kotlin.services.computeoptimizer.model.LicenseModel? = builder.licenseModel
    /**
     * The name of the license for the application that runs on the instance.
     */
    public val licenseName: aws.sdk.kotlin.services.computeoptimizer.model.LicenseName? = builder.licenseName
    /**
     * The version of the license for the application that runs on the instance.
     */
    public val licenseVersion: kotlin.String? = builder.licenseVersion
    /**
     * The list of metric sources required to generate recommendations for commercial software licenses.
     */
    public val metricsSource: List<MetricSource>? = builder.metricsSource
    /**
     * The current number of cores associated with the instance.
     */
    public val numberOfCores: kotlin.Int = builder.numberOfCores
    /**
     * The operating system of the instance.
     */
    public val operatingSystem: kotlin.String? = builder.operatingSystem

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LicenseConfiguration(")
        append("instanceType=$instanceType,")
        append("licenseEdition=$licenseEdition,")
        append("licenseModel=$licenseModel,")
        append("licenseName=$licenseName,")
        append("licenseVersion=$licenseVersion,")
        append("metricsSource=$metricsSource,")
        append("numberOfCores=$numberOfCores,")
        append("operatingSystem=$operatingSystem")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceType?.hashCode() ?: 0
        result = 31 * result + (licenseEdition?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (licenseName?.hashCode() ?: 0)
        result = 31 * result + (licenseVersion?.hashCode() ?: 0)
        result = 31 * result + (metricsSource?.hashCode() ?: 0)
        result = 31 * result + (numberOfCores)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LicenseConfiguration

        if (instanceType != other.instanceType) return false
        if (licenseEdition != other.licenseEdition) return false
        if (licenseModel != other.licenseModel) return false
        if (licenseName != other.licenseName) return false
        if (licenseVersion != other.licenseVersion) return false
        if (metricsSource != other.metricsSource) return false
        if (numberOfCores != other.numberOfCores) return false
        if (operatingSystem != other.operatingSystem) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The instance type used in the license.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The edition of the license for the application that runs on the instance.
         */
        public var licenseEdition: aws.sdk.kotlin.services.computeoptimizer.model.LicenseEdition? = null
        /**
         * The license type associated with the instance.
         */
        public var licenseModel: aws.sdk.kotlin.services.computeoptimizer.model.LicenseModel? = null
        /**
         * The name of the license for the application that runs on the instance.
         */
        public var licenseName: aws.sdk.kotlin.services.computeoptimizer.model.LicenseName? = null
        /**
         * The version of the license for the application that runs on the instance.
         */
        public var licenseVersion: kotlin.String? = null
        /**
         * The list of metric sources required to generate recommendations for commercial software licenses.
         */
        public var metricsSource: List<MetricSource>? = null
        /**
         * The current number of cores associated with the instance.
         */
        public var numberOfCores: kotlin.Int = 0
        /**
         * The operating system of the instance.
         */
        public var operatingSystem: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration) : this() {
            this.instanceType = x.instanceType
            this.licenseEdition = x.licenseEdition
            this.licenseModel = x.licenseModel
            this.licenseName = x.licenseName
            this.licenseVersion = x.licenseVersion
            this.metricsSource = x.metricsSource
            this.numberOfCores = x.numberOfCores
            this.operatingSystem = x.operatingSystem
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LicenseConfiguration = LicenseConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
