// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a recommendation option for an Amazon EC2 instance.
 */
public class InstanceRecommendationOption private constructor(builder: Builder) {
    /**
     * Describes the GPU accelerator settings for the recommended instance type.
     */
    public val instanceGpuInfo: aws.sdk.kotlin.services.computeoptimizer.model.GpuInfo? = builder.instanceGpuInfo
    /**
     * The instance type of the instance recommendation.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The level of effort required to migrate from the current instance type to the recommended instance type.
     *
     * For example, the migration effort is `Low` if Amazon EMR is the inferred workload type and an Amazon Web Services Graviton instance type is recommended. The migration effort is `Medium` if a workload type couldn't be inferred but an Amazon Web Services Graviton instance type is recommended. The migration effort is `VeryLow` if both the current and recommended instance types are of the same CPU architecture.
     */
    public val migrationEffort: aws.sdk.kotlin.services.computeoptimizer.model.MigrationEffort? = builder.migrationEffort
    /**
     * The performance risk of the instance recommendation option.
     *
     * Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.
     *
     * The value ranges from `0` - `4`, with `0` meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.
     */
    public val performanceRisk: kotlin.Double = builder.performanceRisk
    /**
     * Describes the configuration differences between the current instance and the recommended instance type. You should consider the configuration differences before migrating your workloads from the current instance to the recommended instance type. The [Change the instance type guide for Linux](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html) and [Change the instance type guide for Windows](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html) provide general guidance for getting started with an instance migration.
     *
     * Platform differences include:
     * + **`Hypervisor`** — The hypervisor of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses a Nitro hypervisor and the current instance uses a Xen hypervisor. The differences that you should consider between these hypervisors are covered in the [Nitro Hypervisor](http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor) section of the Amazon EC2 frequently asked questions. For more information, see [Instances built on the Nitro System](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances) in the *Amazon EC2 User Guide for Linux*, or [Instances built on the Nitro System](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances) in the *Amazon EC2 User Guide for Windows*.
     * + **`NetworkInterface`** — The network interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type supports enhanced networking and the current instance might not. To enable enhanced networking for the recommended instance type, you must install the Elastic Network Adapter (ENA) driver or the Intel 82599 Virtual Function driver. For more information, see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage) and [Enhanced networking on Linux](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html) in the *Amazon EC2 User Guide for Linux*, or [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage) and [Enhanced networking on Windows](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html) in the *Amazon EC2 User Guide for Windows*.
     * + **`StorageInterface`** — The storage interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses an NVMe storage interface and the current instance does not. To access NVMe volumes for the recommended instance type, you will need to install or upgrade the NVMe driver. For more information, see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage) and [Amazon EBS and NVMe on Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html) in the *Amazon EC2 User Guide for Linux*, or [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage) and [Amazon EBS and NVMe on Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html) in the *Amazon EC2 User Guide for Windows*.
     * + **`InstanceStoreAvailability`** — The recommended instance type does not support instance store volumes and the current instance does. Before migrating, you might need to back up the data on your instance store volumes if you want to preserve them. For more information, see [How do I back up an instance store volume on my Amazon EC2 instance to Amazon EBS?](https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/) in the *Amazon Web Services Premium Support Knowledge Base*. For more information, see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage) and [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux*, or see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage) and [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Windows*.
     * + **`VirtualizationType`** — The recommended instance type uses the hardware virtual machine (HVM) virtualization type and the current instance uses the paravirtual (PV) virtualization type. For more information about the differences between these virtualization types, see [Linux AMI virtualization types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html) in the *Amazon EC2 User Guide for Linux*, or [Windows AMI virtualization types](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types) in the *Amazon EC2 User Guide for Windows*.
     * + **`Architecture`** — The CPU architecture between the recommended instance type and the current instance is different. For example, the recommended instance type might use an Arm CPU architecture and the current instance type might use a different one, such as x86. Before migrating, you should consider recompiling the software on your instance for the new architecture. Alternatively, you might switch to an Amazon Machine Image (AMI) that supports the new architecture. For more information about the CPU architecture for each instance type, see [Amazon EC2 Instance Types](http://aws.amazon.com/ec2/instance-types/).
     */
    public val platformDifferences: List<PlatformDifference>? = builder.platformDifferences
    /**
     * An array of objects that describe the projected utilization metrics of the instance recommendation option.
     *
     * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
     */
    public val projectedUtilizationMetrics: List<UtilizationMetric>? = builder.projectedUtilizationMetrics
    /**
     * The rank of the instance recommendation option.
     *
     * The top recommendation option is ranked as `1`.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * An object that describes the savings opportunity for the instance recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity
    /**
     * An object that describes the savings opportunity for the instance recommendation option that includes Savings Plans and Reserved Instances discounts. Savings opportunity includes the estimated monthly savings and percentage.
     */
    public val savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts? = builder.savingsOpportunityAfterDiscounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceRecommendationOption(")
        append("instanceGpuInfo=$instanceGpuInfo,")
        append("instanceType=$instanceType,")
        append("migrationEffort=$migrationEffort,")
        append("performanceRisk=$performanceRisk,")
        append("platformDifferences=$platformDifferences,")
        append("projectedUtilizationMetrics=$projectedUtilizationMetrics,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity,")
        append("savingsOpportunityAfterDiscounts=$savingsOpportunityAfterDiscounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceGpuInfo?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (migrationEffort?.hashCode() ?: 0)
        result = 31 * result + (performanceRisk.hashCode())
        result = 31 * result + (platformDifferences?.hashCode() ?: 0)
        result = 31 * result + (projectedUtilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunityAfterDiscounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceRecommendationOption

        if (instanceGpuInfo != other.instanceGpuInfo) return false
        if (instanceType != other.instanceType) return false
        if (migrationEffort != other.migrationEffort) return false
        if (!(performanceRisk?.equals(other.performanceRisk) ?: (other.performanceRisk == null))) return false
        if (platformDifferences != other.platformDifferences) return false
        if (projectedUtilizationMetrics != other.projectedUtilizationMetrics) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false
        if (savingsOpportunityAfterDiscounts != other.savingsOpportunityAfterDiscounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the GPU accelerator settings for the recommended instance type.
         */
        public var instanceGpuInfo: aws.sdk.kotlin.services.computeoptimizer.model.GpuInfo? = null
        /**
         * The instance type of the instance recommendation.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The level of effort required to migrate from the current instance type to the recommended instance type.
         *
         * For example, the migration effort is `Low` if Amazon EMR is the inferred workload type and an Amazon Web Services Graviton instance type is recommended. The migration effort is `Medium` if a workload type couldn't be inferred but an Amazon Web Services Graviton instance type is recommended. The migration effort is `VeryLow` if both the current and recommended instance types are of the same CPU architecture.
         */
        public var migrationEffort: aws.sdk.kotlin.services.computeoptimizer.model.MigrationEffort? = null
        /**
         * The performance risk of the instance recommendation option.
         *
         * Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.
         *
         * The value ranges from `0` - `4`, with `0` meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.
         */
        public var performanceRisk: kotlin.Double = 0.0
        /**
         * Describes the configuration differences between the current instance and the recommended instance type. You should consider the configuration differences before migrating your workloads from the current instance to the recommended instance type. The [Change the instance type guide for Linux](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html) and [Change the instance type guide for Windows](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html) provide general guidance for getting started with an instance migration.
         *
         * Platform differences include:
         * + **`Hypervisor`** — The hypervisor of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses a Nitro hypervisor and the current instance uses a Xen hypervisor. The differences that you should consider between these hypervisors are covered in the [Nitro Hypervisor](http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor) section of the Amazon EC2 frequently asked questions. For more information, see [Instances built on the Nitro System](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances) in the *Amazon EC2 User Guide for Linux*, or [Instances built on the Nitro System](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances) in the *Amazon EC2 User Guide for Windows*.
         * + **`NetworkInterface`** — The network interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type supports enhanced networking and the current instance might not. To enable enhanced networking for the recommended instance type, you must install the Elastic Network Adapter (ENA) driver or the Intel 82599 Virtual Function driver. For more information, see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage) and [Enhanced networking on Linux](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html) in the *Amazon EC2 User Guide for Linux*, or [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage) and [Enhanced networking on Windows](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html) in the *Amazon EC2 User Guide for Windows*.
         * + **`StorageInterface`** — The storage interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses an NVMe storage interface and the current instance does not. To access NVMe volumes for the recommended instance type, you will need to install or upgrade the NVMe driver. For more information, see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage) and [Amazon EBS and NVMe on Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html) in the *Amazon EC2 User Guide for Linux*, or [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage) and [Amazon EBS and NVMe on Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html) in the *Amazon EC2 User Guide for Windows*.
         * + **`InstanceStoreAvailability`** — The recommended instance type does not support instance store volumes and the current instance does. Before migrating, you might need to back up the data on your instance store volumes if you want to preserve them. For more information, see [How do I back up an instance store volume on my Amazon EC2 instance to Amazon EBS?](https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/) in the *Amazon Web Services Premium Support Knowledge Base*. For more information, see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage) and [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux*, or see [Networking and storage features](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage) and [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Windows*.
         * + **`VirtualizationType`** — The recommended instance type uses the hardware virtual machine (HVM) virtualization type and the current instance uses the paravirtual (PV) virtualization type. For more information about the differences between these virtualization types, see [Linux AMI virtualization types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html) in the *Amazon EC2 User Guide for Linux*, or [Windows AMI virtualization types](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types) in the *Amazon EC2 User Guide for Windows*.
         * + **`Architecture`** — The CPU architecture between the recommended instance type and the current instance is different. For example, the recommended instance type might use an Arm CPU architecture and the current instance type might use a different one, such as x86. Before migrating, you should consider recompiling the software on your instance for the new architecture. Alternatively, you might switch to an Amazon Machine Image (AMI) that supports the new architecture. For more information about the CPU architecture for each instance type, see [Amazon EC2 Instance Types](http://aws.amazon.com/ec2/instance-types/).
         */
        public var platformDifferences: List<PlatformDifference>? = null
        /**
         * An array of objects that describe the projected utilization metrics of the instance recommendation option.
         *
         * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
         */
        public var projectedUtilizationMetrics: List<UtilizationMetric>? = null
        /**
         * The rank of the instance recommendation option.
         *
         * The top recommendation option is ranked as `1`.
         */
        public var rank: kotlin.Int = 0
        /**
         * An object that describes the savings opportunity for the instance recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * An object that describes the savings opportunity for the instance recommendation option that includes Savings Plans and Reserved Instances discounts. Savings opportunity includes the estimated monthly savings and percentage.
         */
        public var savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption) : this() {
            this.instanceGpuInfo = x.instanceGpuInfo
            this.instanceType = x.instanceType
            this.migrationEffort = x.migrationEffort
            this.performanceRisk = x.performanceRisk
            this.platformDifferences = x.platformDifferences
            this.projectedUtilizationMetrics = x.projectedUtilizationMetrics
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
            this.savingsOpportunityAfterDiscounts = x.savingsOpportunityAfterDiscounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendationOption = InstanceRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.GpuInfo] inside the given [block]
         */
        public fun instanceGpuInfo(block: aws.sdk.kotlin.services.computeoptimizer.model.GpuInfo.Builder.() -> kotlin.Unit) {
            this.instanceGpuInfo = aws.sdk.kotlin.services.computeoptimizer.model.GpuInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts] inside the given [block]
         */
        public fun savingsOpportunityAfterDiscounts(block: aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts.Builder.() -> kotlin.Unit) {
            this.savingsOpportunityAfterDiscounts = aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
