// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetIdleRecommendationsRequest private constructor(builder: Builder) {
    /**
     * Return the idle resource recommendations to the specified Amazon Web Services account IDs.
     *
     * If your account is the management account or the delegated administrator of an organization, use this parameter to return the idle resource recommendations to specific member accounts.
     *
     * You can only specify one account ID per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * An array of objects to specify a filter that returns a more specific list of idle resource recommendations.
     */
    public val filters: List<IdleRecommendationFilter>? = builder.filters
    /**
     * The maximum number of idle resource recommendations to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of idle resource recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The order to sort the idle resource recommendations.
     */
    public val orderBy: aws.sdk.kotlin.services.computeoptimizer.model.OrderBy? = builder.orderBy
    /**
     * The ARN that identifies the idle resource.
     */
    public val resourceArns: List<String>? = builder.resourceArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetIdleRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetIdleRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("orderBy=$orderBy,")
        append("resourceArns=$resourceArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetIdleRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (orderBy != other.orderBy) return false
        if (resourceArns != other.resourceArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetIdleRecommendationsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Return the idle resource recommendations to the specified Amazon Web Services account IDs.
         *
         * If your account is the management account or the delegated administrator of an organization, use this parameter to return the idle resource recommendations to specific member accounts.
         *
         * You can only specify one account ID per request.
         */
        public var accountIds: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of idle resource recommendations.
         */
        public var filters: List<IdleRecommendationFilter>? = null
        /**
         * The maximum number of idle resource recommendations to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of idle resource recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The order to sort the idle resource recommendations.
         */
        public var orderBy: aws.sdk.kotlin.services.computeoptimizer.model.OrderBy? = null
        /**
         * The ARN that identifies the idle resource.
         */
        public var resourceArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetIdleRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.orderBy = x.orderBy
            this.resourceArns = x.resourceArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetIdleRecommendationsRequest = GetIdleRecommendationsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.OrderBy] inside the given [block]
         */
        public fun orderBy(block: aws.sdk.kotlin.services.computeoptimizer.model.OrderBy.Builder.() -> kotlin.Unit) {
            this.orderBy = aws.sdk.kotlin.services.computeoptimizer.model.OrderBy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
