// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the effective recommendation preferences for a resource.
 */
public class EffectiveRecommendationPreferences private constructor(builder: Builder) {
    /**
     * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
     *
     * For example, when you specify `AWS_ARM64` with:
     * + A GetEC2InstanceRecommendations or GetAutoScalingGroupRecommendations request, Compute Optimizer returns recommendations that consist of Graviton instance types only.
     * + A GetEC2RecommendationProjectedMetrics request, Compute Optimizer returns projected utilization metrics for Graviton instance type recommendations only.
     * + A ExportEC2InstanceRecommendations or ExportAutoScalingGroupRecommendations request, Compute Optimizer exports recommendations that consist of Graviton instance types only.
     */
    public val cpuVendorArchitectures: List<CpuVendorArchitecture>? = builder.cpuVendorArchitectures
    /**
     * Describes the activation status of the enhanced infrastructure metrics preference.
     *
     * A status of `Active` confirms that the preference is applied in the latest recommendation refresh, and a status of `Inactive` confirms that it's not yet applied to recommendations.
     *
     * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public val enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = builder.enhancedInfrastructureMetrics
    /**
     * An object that describes the external metrics recommendation preference.
     *
     *  If the preference is applied in the latest recommendation refresh, an object with a valid `source` value appears in the response. If the preference isn't applied to the recommendations already, then this object doesn't appear in the response.
     */
    public val externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = builder.externalMetricsPreference
    /**
     * Describes the activation status of the inferred workload types preference.
     *
     * A status of `Active` confirms that the preference is applied in the latest recommendation refresh. A status of `Inactive` confirms that it's not yet applied to recommendations.
     */
    public val inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = builder.inferredWorkloadTypes
    /**
     * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
     */
    public val lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = builder.lookBackPeriod
    /**
     * The resource type values that are considered as candidates when generating rightsizing recommendations.
     */
    public val preferredResources: List<EffectivePreferredResource>? = builder.preferredResources
    /**
     * Describes the savings estimation mode applied for calculating savings opportunity for a resource.
     */
    public val savingsEstimationMode: aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsEstimationMode? = builder.savingsEstimationMode
    /**
     * The resource’s CPU and memory utilization preferences, such as threshold and headroom, that are used to generate rightsizing recommendations.
     *
     * This preference is only available for the Amazon EC2 instance resource type.
     */
    public val utilizationPreferences: List<UtilizationPreference>? = builder.utilizationPreferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EffectiveRecommendationPreferences(")
        append("cpuVendorArchitectures=$cpuVendorArchitectures,")
        append("enhancedInfrastructureMetrics=$enhancedInfrastructureMetrics,")
        append("externalMetricsPreference=$externalMetricsPreference,")
        append("inferredWorkloadTypes=$inferredWorkloadTypes,")
        append("lookBackPeriod=$lookBackPeriod,")
        append("preferredResources=$preferredResources,")
        append("savingsEstimationMode=$savingsEstimationMode,")
        append("utilizationPreferences=$utilizationPreferences")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpuVendorArchitectures?.hashCode() ?: 0
        result = 31 * result + (enhancedInfrastructureMetrics?.hashCode() ?: 0)
        result = 31 * result + (externalMetricsPreference?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadTypes?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriod?.hashCode() ?: 0)
        result = 31 * result + (preferredResources?.hashCode() ?: 0)
        result = 31 * result + (savingsEstimationMode?.hashCode() ?: 0)
        result = 31 * result + (utilizationPreferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EffectiveRecommendationPreferences

        if (cpuVendorArchitectures != other.cpuVendorArchitectures) return false
        if (enhancedInfrastructureMetrics != other.enhancedInfrastructureMetrics) return false
        if (externalMetricsPreference != other.externalMetricsPreference) return false
        if (inferredWorkloadTypes != other.inferredWorkloadTypes) return false
        if (lookBackPeriod != other.lookBackPeriod) return false
        if (preferredResources != other.preferredResources) return false
        if (savingsEstimationMode != other.savingsEstimationMode) return false
        if (utilizationPreferences != other.utilizationPreferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
         *
         * For example, when you specify `AWS_ARM64` with:
         * + A GetEC2InstanceRecommendations or GetAutoScalingGroupRecommendations request, Compute Optimizer returns recommendations that consist of Graviton instance types only.
         * + A GetEC2RecommendationProjectedMetrics request, Compute Optimizer returns projected utilization metrics for Graviton instance type recommendations only.
         * + A ExportEC2InstanceRecommendations or ExportAutoScalingGroupRecommendations request, Compute Optimizer exports recommendations that consist of Graviton instance types only.
         */
        public var cpuVendorArchitectures: List<CpuVendorArchitecture>? = null
        /**
         * Describes the activation status of the enhanced infrastructure metrics preference.
         *
         * A status of `Active` confirms that the preference is applied in the latest recommendation refresh, and a status of `Inactive` confirms that it's not yet applied to recommendations.
         *
         * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         */
        public var enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = null
        /**
         * An object that describes the external metrics recommendation preference.
         *
         *  If the preference is applied in the latest recommendation refresh, an object with a valid `source` value appears in the response. If the preference isn't applied to the recommendations already, then this object doesn't appear in the response.
         */
        public var externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = null
        /**
         * Describes the activation status of the inferred workload types preference.
         *
         * A status of `Active` confirms that the preference is applied in the latest recommendation refresh. A status of `Inactive` confirms that it's not yet applied to recommendations.
         */
        public var inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = null
        /**
         * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
         */
        public var lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = null
        /**
         * The resource type values that are considered as candidates when generating rightsizing recommendations.
         */
        public var preferredResources: List<EffectivePreferredResource>? = null
        /**
         * Describes the savings estimation mode applied for calculating savings opportunity for a resource.
         */
        public var savingsEstimationMode: aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsEstimationMode? = null
        /**
         * The resource’s CPU and memory utilization preferences, such as threshold and headroom, that are used to generate rightsizing recommendations.
         *
         * This preference is only available for the Amazon EC2 instance resource type.
         */
        public var utilizationPreferences: List<UtilizationPreference>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences) : this() {
            this.cpuVendorArchitectures = x.cpuVendorArchitectures
            this.enhancedInfrastructureMetrics = x.enhancedInfrastructureMetrics
            this.externalMetricsPreference = x.externalMetricsPreference
            this.inferredWorkloadTypes = x.inferredWorkloadTypes
            this.lookBackPeriod = x.lookBackPeriod
            this.preferredResources = x.preferredResources
            this.savingsEstimationMode = x.savingsEstimationMode
            this.utilizationPreferences = x.utilizationPreferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences = EffectiveRecommendationPreferences(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference] inside the given [block]
         */
        public fun externalMetricsPreference(block: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.Builder.() -> kotlin.Unit) {
            this.externalMetricsPreference = aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsEstimationMode] inside the given [block]
         */
        public fun savingsEstimationMode(block: aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsEstimationMode.Builder.() -> kotlin.Unit) {
            this.savingsEstimationMode = aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsEstimationMode.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
