// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon ECS service recommendation.
 */
public class EcsServiceRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the Amazon ECS service.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The risk of the current Amazon ECS service not meeting the performance needs of its workloads. The higher the risk, the more likely the current service can't meet the performance requirements of its workload.
     */
    public val currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = builder.currentPerformanceRisk
    /**
     * The configuration of the current Amazon ECS service.
     */
    public val currentServiceConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration? = builder.currentServiceConfiguration
    /**
     * Describes the effective recommendation preferences for Amazon ECS services.
     */
    public val effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EcsEffectiveRecommendationPreferences? = builder.effectiveRecommendationPreferences
    /**
     * The finding classification of an Amazon ECS service.
     *
     * Findings for Amazon ECS services include:
     * + **`Underprovisioned`** — When Compute Optimizer detects that there’s not enough memory or CPU, an Amazon ECS service is considered under-provisioned. An under-provisioned service might result in poor application performance.
     * + **`Overprovisioned`** — When Compute Optimizer detects that there’s excessive memory or CPU, an Amazon ECS service is considered over-provisioned. An over-provisioned service might result in additional infrastructure costs.
     * + **`Optimized`** — When both the CPU and memory of your Amazon ECS service meet the performance requirements of your workload, the service is considered optimized.
     */
    public val finding: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFinding? = builder.finding
    /**
     * The reason for the finding classification of an Amazon ECS service.
     *
     * Finding reason codes for Amazon ECS services include:
     * + **`CPUUnderprovisioned`** — The service CPU configuration can be sized up to enhance the performance of your workload. This is identified by analyzing the `CPUUtilization` metric of the current service during the look-back period.
     * + **`CPUOverprovisioned`** — The service CPU configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `CPUUtilization` metric of the current service during the look-back period.
     * + **`MemoryUnderprovisioned`** — The service memory configuration can be sized up to enhance the performance of your workload. This is identified by analyzing the `MemoryUtilization` metric of the current service during the look-back period.
     * + **`MemoryOverprovisioned`** — The service memory configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `MemoryUtilization` metric of the current service during the look-back period.
     */
    public val findingReasonCodes: List<EcsServiceRecommendationFindingReasonCode>? = builder.findingReasonCodes
    /**
     * The timestamp of when the Amazon ECS service recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The launch type the Amazon ECS service is using.
     *
     * Compute Optimizer only supports the Fargate launch type.
     */
    public val launchType: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceLaunchType? = builder.launchType
    /**
     * The number of days the Amazon ECS service utilization metrics were analyzed.
     */
    public val lookbackPeriodInDays: kotlin.Double = builder.lookbackPeriodInDays
    /**
     * The Amazon Resource Name (ARN) of the current Amazon ECS service.
     *
     *  The following is the format of the ARN:
     *
     * `arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name`
     */
    public val serviceArn: kotlin.String? = builder.serviceArn
    /**
     * An array of objects that describe the recommendation options for the Amazon ECS service.
     */
    public val serviceRecommendationOptions: List<EcsServiceRecommendationOption>? = builder.serviceRecommendationOptions
    /**
     * A list of tags assigned to your Amazon ECS service recommendations.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An array of objects that describe the utilization metrics of the Amazon ECS service.
     */
    public val utilizationMetrics: List<EcsServiceUtilizationMetric>? = builder.utilizationMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsServiceRecommendation(")
        append("accountId=$accountId,")
        append("currentPerformanceRisk=$currentPerformanceRisk,")
        append("currentServiceConfiguration=$currentServiceConfiguration,")
        append("effectiveRecommendationPreferences=$effectiveRecommendationPreferences,")
        append("finding=$finding,")
        append("findingReasonCodes=$findingReasonCodes,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("launchType=$launchType,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("serviceArn=$serviceArn,")
        append("serviceRecommendationOptions=$serviceRecommendationOptions,")
        append("tags=$tags,")
        append("utilizationMetrics=$utilizationMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentPerformanceRisk?.hashCode() ?: 0)
        result = 31 * result + (currentServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (effectiveRecommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (findingReasonCodes?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (lookbackPeriodInDays.hashCode())
        result = 31 * result + (serviceArn?.hashCode() ?: 0)
        result = 31 * result + (serviceRecommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsServiceRecommendation

        if (accountId != other.accountId) return false
        if (currentPerformanceRisk != other.currentPerformanceRisk) return false
        if (currentServiceConfiguration != other.currentServiceConfiguration) return false
        if (effectiveRecommendationPreferences != other.effectiveRecommendationPreferences) return false
        if (finding != other.finding) return false
        if (findingReasonCodes != other.findingReasonCodes) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (launchType != other.launchType) return false
        if (!(lookbackPeriodInDays?.equals(other.lookbackPeriodInDays) ?: (other.lookbackPeriodInDays == null))) return false
        if (serviceArn != other.serviceArn) return false
        if (serviceRecommendationOptions != other.serviceRecommendationOptions) return false
        if (tags != other.tags) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the Amazon ECS service.
         */
        public var accountId: kotlin.String? = null
        /**
         * The risk of the current Amazon ECS service not meeting the performance needs of its workloads. The higher the risk, the more likely the current service can't meet the performance requirements of its workload.
         */
        public var currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = null
        /**
         * The configuration of the current Amazon ECS service.
         */
        public var currentServiceConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration? = null
        /**
         * Describes the effective recommendation preferences for Amazon ECS services.
         */
        public var effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EcsEffectiveRecommendationPreferences? = null
        /**
         * The finding classification of an Amazon ECS service.
         *
         * Findings for Amazon ECS services include:
         * + **`Underprovisioned`** — When Compute Optimizer detects that there’s not enough memory or CPU, an Amazon ECS service is considered under-provisioned. An under-provisioned service might result in poor application performance.
         * + **`Overprovisioned`** — When Compute Optimizer detects that there’s excessive memory or CPU, an Amazon ECS service is considered over-provisioned. An over-provisioned service might result in additional infrastructure costs.
         * + **`Optimized`** — When both the CPU and memory of your Amazon ECS service meet the performance requirements of your workload, the service is considered optimized.
         */
        public var finding: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFinding? = null
        /**
         * The reason for the finding classification of an Amazon ECS service.
         *
         * Finding reason codes for Amazon ECS services include:
         * + **`CPUUnderprovisioned`** — The service CPU configuration can be sized up to enhance the performance of your workload. This is identified by analyzing the `CPUUtilization` metric of the current service during the look-back period.
         * + **`CPUOverprovisioned`** — The service CPU configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `CPUUtilization` metric of the current service during the look-back period.
         * + **`MemoryUnderprovisioned`** — The service memory configuration can be sized up to enhance the performance of your workload. This is identified by analyzing the `MemoryUtilization` metric of the current service during the look-back period.
         * + **`MemoryOverprovisioned`** — The service memory configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `MemoryUtilization` metric of the current service during the look-back period.
         */
        public var findingReasonCodes: List<EcsServiceRecommendationFindingReasonCode>? = null
        /**
         * The timestamp of when the Amazon ECS service recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The launch type the Amazon ECS service is using.
         *
         * Compute Optimizer only supports the Fargate launch type.
         */
        public var launchType: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceLaunchType? = null
        /**
         * The number of days the Amazon ECS service utilization metrics were analyzed.
         */
        public var lookbackPeriodInDays: kotlin.Double = 0.0
        /**
         * The Amazon Resource Name (ARN) of the current Amazon ECS service.
         *
         *  The following is the format of the ARN:
         *
         * `arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name`
         */
        public var serviceArn: kotlin.String? = null
        /**
         * An array of objects that describe the recommendation options for the Amazon ECS service.
         */
        public var serviceRecommendationOptions: List<EcsServiceRecommendationOption>? = null
        /**
         * A list of tags assigned to your Amazon ECS service recommendations.
         */
        public var tags: List<Tag>? = null
        /**
         * An array of objects that describe the utilization metrics of the Amazon ECS service.
         */
        public var utilizationMetrics: List<EcsServiceUtilizationMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendation) : this() {
            this.accountId = x.accountId
            this.currentPerformanceRisk = x.currentPerformanceRisk
            this.currentServiceConfiguration = x.currentServiceConfiguration
            this.effectiveRecommendationPreferences = x.effectiveRecommendationPreferences
            this.finding = x.finding
            this.findingReasonCodes = x.findingReasonCodes
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.launchType = x.launchType
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.serviceArn = x.serviceArn
            this.serviceRecommendationOptions = x.serviceRecommendationOptions
            this.tags = x.tags
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendation = EcsServiceRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration] inside the given [block]
         */
        public fun currentServiceConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration.Builder.() -> kotlin.Unit) {
            this.currentServiceConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.EcsEffectiveRecommendationPreferences] inside the given [block]
         */
        public fun effectiveRecommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.EcsEffectiveRecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.effectiveRecommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.EcsEffectiveRecommendationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
