// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the scope of a recommendation preference.
 *
 * Recommendation preferences can be created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
 *
 * You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels. You can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a scope name of `ResourceArn` and a scope value of the Auto Scaling group Amazon Resource Name (ARN). This will configure the preference for all instances that are part of the specified Auto Scaling group. You also cannot create recommendation preferences at the resource level for instances that are part of an Auto Scaling group. You can create recommendation preferences at the resource level only for standalone instances.
 */
public class Scope private constructor(builder: Builder) {
    /**
     * The name of the scope.
     *
     * The following scopes are possible:
     * + `Organization` - Specifies that the recommendation preference applies at the organization level, for all member accounts of an organization.
     * + `AccountId` - Specifies that the recommendation preference applies at the account level, for all resources of a given resource type in an account.
     * + `ResourceArn` - Specifies that the recommendation preference applies at the individual resource level.
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.ScopeName? = builder.name
    /**
     * The value of the scope.
     *
     * If you specified the `name` of the scope as:
     * + `Organization` - The `value` must be `ALL_ACCOUNTS`.
     * + `AccountId` - The `value` must be a 12-digit Amazon Web Services account ID.
     * + `ResourceArn` - The `value` must be the Amazon Resource Name (ARN) of an EC2 instance or an Auto Scaling group.
     *
     * Only EC2 instance and Auto Scaling group ARNs are currently supported.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.Scope = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Scope(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Scope

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.Scope = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the scope.
         *
         * The following scopes are possible:
         * + `Organization` - Specifies that the recommendation preference applies at the organization level, for all member accounts of an organization.
         * + `AccountId` - Specifies that the recommendation preference applies at the account level, for all resources of a given resource type in an account.
         * + `ResourceArn` - Specifies that the recommendation preference applies at the individual resource level.
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.ScopeName? = null
        /**
         * The value of the scope.
         *
         * If you specified the `name` of the scope as:
         * + `Organization` - The `value` must be `ALL_ACCOUNTS`.
         * + `AccountId` - The `value` must be a 12-digit Amazon Web Services account ID.
         * + `ResourceArn` - The `value` must be the Amazon Resource Name (ARN) of an EC2 instance or an Auto Scaling group.
         *
         * Only EC2 instance and Auto Scaling group ARNs are currently supported.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.Scope) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.Scope = Scope(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
