// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a projected utilization metric of a recommendation option.
 *
 * The `Cpu` and `Memory` metrics are the only projected utilization metrics returned when you run the GetEC2RecommendationProjectedMetrics action. Additionally, the `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
 */
public class RecommendedOptionProjectedMetric private constructor(builder: Builder) {
    /**
     * An array of objects that describe a projected utilization metric.
     */
    public val projectedMetrics: List<ProjectedMetric>? = builder.projectedMetrics
    /**
     * The rank of the recommendation option projected metric.
     *
     * The top recommendation option is ranked as `1`.
     *
     * The projected metric rank correlates to the recommendation option rank. For example, the projected metric ranked as `1` is related to the recommendation option that is also ranked as `1` in the same response.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * The recommended instance type.
     */
    public val recommendedInstanceType: kotlin.String? = builder.recommendedInstanceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RecommendedOptionProjectedMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendedOptionProjectedMetric(")
        append("projectedMetrics=$projectedMetrics,")
        append("rank=$rank,")
        append("recommendedInstanceType=$recommendedInstanceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = projectedMetrics?.hashCode() ?: 0
        result = 31 * result + (rank)
        result = 31 * result + (recommendedInstanceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendedOptionProjectedMetric

        if (projectedMetrics != other.projectedMetrics) return false
        if (rank != other.rank) return false
        if (recommendedInstanceType != other.recommendedInstanceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RecommendedOptionProjectedMetric = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of objects that describe a projected utilization metric.
         */
        public var projectedMetrics: List<ProjectedMetric>? = null
        /**
         * The rank of the recommendation option projected metric.
         *
         * The top recommendation option is ranked as `1`.
         *
         * The projected metric rank correlates to the recommendation option rank. For example, the projected metric ranked as `1` is related to the recommendation option that is also ranked as `1` in the same response.
         */
        public var rank: kotlin.Int = 0
        /**
         * The recommended instance type.
         */
        public var recommendedInstanceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RecommendedOptionProjectedMetric) : this() {
            this.projectedMetrics = x.projectedMetrics
            this.rank = x.rank
            this.recommendedInstanceType = x.recommendedInstanceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RecommendedOptionProjectedMetric = RecommendedOptionProjectedMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
