// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the recommendation options for Amazon RDS storage.
 */
public class RdsdbStorageRecommendationOption private constructor(builder: Builder) {
    /**
     * The rank identifier of the RDS storage recommendation option.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
     *
     * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
     *
     * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity
    /**
     * Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation option.
     *
     *  Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.
     */
    public val savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.RdsStorageSavingsOpportunityAfterDiscounts? = builder.savingsOpportunityAfterDiscounts
    /**
     * The recommended storage configuration.
     */
    public val storageConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration? = builder.storageConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbStorageRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsdbStorageRecommendationOption(")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity,")
        append("savingsOpportunityAfterDiscounts=$savingsOpportunityAfterDiscounts,")
        append("storageConfiguration=$storageConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = rank
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunityAfterDiscounts?.hashCode() ?: 0)
        result = 31 * result + (storageConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsdbStorageRecommendationOption

        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false
        if (savingsOpportunityAfterDiscounts != other.savingsOpportunityAfterDiscounts) return false
        if (storageConfiguration != other.storageConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbStorageRecommendationOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The rank identifier of the RDS storage recommendation option.
         */
        public var rank: kotlin.Int = 0
        /**
         * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
         *
         * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
         *
         * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation option.
         *
         *  Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.
         */
        public var savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.RdsStorageSavingsOpportunityAfterDiscounts? = null
        /**
         * The recommended storage configuration.
         */
        public var storageConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RdsdbStorageRecommendationOption) : this() {
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
            this.savingsOpportunityAfterDiscounts = x.savingsOpportunityAfterDiscounts
            this.storageConfiguration = x.storageConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RdsdbStorageRecommendationOption = RdsdbStorageRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RdsStorageSavingsOpportunityAfterDiscounts] inside the given [block]
         */
        public fun savingsOpportunityAfterDiscounts(block: aws.sdk.kotlin.services.computeoptimizer.model.RdsStorageSavingsOpportunityAfterDiscounts.Builder.() -> kotlin.Unit) {
            this.savingsOpportunityAfterDiscounts = aws.sdk.kotlin.services.computeoptimizer.model.RdsStorageSavingsOpportunityAfterDiscounts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration] inside the given [block]
         */
        public fun storageConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration.Builder.() -> kotlin.Unit) {
            this.storageConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.DbStorageConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
