// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a projected utilization metric of a recommendation option, such as an Amazon EC2 instance. This represents the projected utilization of a recommendation option had you used that resource during the analyzed period.
 *
 * Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.
 *
 * The `Cpu`, `Memory`, `GPU`, and `GPU_MEMORY` metrics are the only projected utilization metrics returned when you run the GetEC2RecommendationProjectedMetrics action. Additionally, these metrics are only returned for resources with the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent) and [Enabling NVIDIA GPU utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent).
 */
public class ProjectedMetric private constructor(builder: Builder) {
    /**
     * The name of the projected utilization metric.
     *
     * The following projected utilization metrics are returned:
     * + `Cpu` - The projected percentage of allocated EC2 compute units that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the processing power required to run an application on the recommendation option.Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.
     * + `Memory` - The percentage of memory that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the amount of memory required to run an application on the recommendation option.Units: PercentThe `Memory` metric is only returned for resources with the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
     * + `GPU` - The projected percentage of allocated GPUs if you adjust your configurations to Compute Optimizer's recommendation option.
     * + `GPU_MEMORY` - The projected percentage of total GPU memory if you adjust your configurations to Compute Optimizer's recommendation option.The `GPU` and `GPU_MEMORY` metrics are only returned for resources with the unified CloudWatch Agent installed on them. For more information, see [Enabling NVIDIA GPU utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent).
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.MetricName? = builder.name
    /**
     * The timestamps of the projected utilization metric.
     */
    public val timestamps: List<Instant>? = builder.timestamps
    /**
     * The values of the projected utilization metrics.
     */
    public val values: List<Double>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.ProjectedMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectedMetric(")
        append("name=$name,")
        append("timestamps=$timestamps,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (timestamps?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectedMetric

        if (name != other.name) return false
        if (timestamps != other.timestamps) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.ProjectedMetric = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the projected utilization metric.
         *
         * The following projected utilization metrics are returned:
         * + `Cpu` - The projected percentage of allocated EC2 compute units that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the processing power required to run an application on the recommendation option.Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.
         * + `Memory` - The percentage of memory that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the amount of memory required to run an application on the recommendation option.Units: PercentThe `Memory` metric is only returned for resources with the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
         * + `GPU` - The projected percentage of allocated GPUs if you adjust your configurations to Compute Optimizer's recommendation option.
         * + `GPU_MEMORY` - The projected percentage of total GPU memory if you adjust your configurations to Compute Optimizer's recommendation option.The `GPU` and `GPU_MEMORY` metrics are only returned for resources with the unified CloudWatch Agent installed on them. For more information, see [Enabling NVIDIA GPU utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent).
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.MetricName? = null
        /**
         * The timestamps of the projected utilization metric.
         */
        public var timestamps: List<Instant>? = null
        /**
         * The values of the projected utilization metrics.
         */
        public var values: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.ProjectedMetric) : this() {
            this.name = x.name
            this.timestamps = x.timestamps
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.ProjectedMetric = ProjectedMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
