// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Lambda function recommendation.
 */
public class LambdaFunctionRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the function.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The amount of memory, in MB, that's allocated to the current function.
     */
    public val currentMemorySize: kotlin.Int = builder.currentMemorySize
    /**
     * The risk of the current Lambda function not meeting the performance needs of its workloads. The higher the risk, the more likely the current Lambda function requires more memory.
     */
    public val currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = builder.currentPerformanceRisk
    /**
     * Describes the effective recommendation preferences for Lambda functions.
     */
    public val effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.LambdaEffectiveRecommendationPreferences? = builder.effectiveRecommendationPreferences
    /**
     * The finding classification of the function.
     *
     * Findings for functions include:
     * + **`Optimized`** — The function is correctly provisioned to run your workload based on its current configuration and its utilization history. This finding classification does not include finding reason codes.
     * + **`NotOptimized`** — The function is performing at a higher level (over-provisioned) or at a lower level (under-provisioned) than required for your workload because its current configuration is not optimal. Over-provisioned resources might lead to unnecessary infrastructure cost, and under-provisioned resources might lead to poor application performance. This finding classification can include the `MemoryUnderprovisioned` and `MemoryUnderprovisioned` finding reason codes.
     * + **`Unavailable`** — Compute Optimizer was unable to generate a recommendation for the function. This could be because the function has not accumulated sufficient metric data, or the function does not qualify for a recommendation. This finding classification can include the `InsufficientData` and `Inconclusive` finding reason codes.Functions with a finding of unavailable are not returned unless you specify the `filter` parameter with a value of `Unavailable` in your `GetLambdaFunctionRecommendations` request.
     */
    public val finding: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendationFinding? = builder.finding
    /**
     * The reason for the finding classification of the function.
     *
     * Functions that have a finding classification of `Optimized` don't have a finding reason code.
     *
     * Finding reason codes for functions include:
     * + **`MemoryOverprovisioned`** — The function is over-provisioned when its memory configuration can be sized down while still meeting the performance requirements of your workload. An over-provisioned function might lead to unnecessary infrastructure cost. This finding reason code is part of the `NotOptimized` finding classification.
     * + **`MemoryUnderprovisioned`** — The function is under-provisioned when its memory configuration doesn't meet the performance requirements of the workload. An under-provisioned function might lead to poor application performance. This finding reason code is part of the `NotOptimized` finding classification.
     * + **`InsufficientData`** — The function does not have sufficient metric data for Compute Optimizer to generate a recommendation. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*. This finding reason code is part of the `Unavailable` finding classification.
     * + **`Inconclusive`** — The function does not qualify for a recommendation because Compute Optimizer cannot generate a recommendation with a high degree of confidence. This finding reason code is part of the `Unavailable` finding classification.
     */
    public val findingReasonCodes: List<LambdaFunctionRecommendationFindingReasonCode>? = builder.findingReasonCodes
    /**
     * The Amazon Resource Name (ARN) of the current function.
     */
    public val functionArn: kotlin.String? = builder.functionArn
    /**
     * The version number of the current function.
     */
    public val functionVersion: kotlin.String? = builder.functionVersion
    /**
     * The timestamp of when the function recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days for which utilization metrics were analyzed for the function.
     */
    public val lookbackPeriodInDays: kotlin.Double = builder.lookbackPeriodInDays
    /**
     * An array of objects that describe the memory configuration recommendation options for the function.
     */
    public val memorySizeRecommendationOptions: List<LambdaFunctionMemoryRecommendationOption>? = builder.memorySizeRecommendationOptions
    /**
     * The number of times your function code was applied during the look-back period.
     */
    public val numberOfInvocations: kotlin.Long = builder.numberOfInvocations
    /**
     * A list of tags assigned to your Lambda function recommendations.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An array of objects that describe the utilization metrics of the function.
     */
    public val utilizationMetrics: List<LambdaFunctionUtilizationMetric>? = builder.utilizationMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionRecommendation(")
        append("accountId=$accountId,")
        append("currentMemorySize=$currentMemorySize,")
        append("currentPerformanceRisk=$currentPerformanceRisk,")
        append("effectiveRecommendationPreferences=$effectiveRecommendationPreferences,")
        append("finding=$finding,")
        append("findingReasonCodes=$findingReasonCodes,")
        append("functionArn=$functionArn,")
        append("functionVersion=$functionVersion,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookbackPeriodInDays=$lookbackPeriodInDays,")
        append("memorySizeRecommendationOptions=$memorySizeRecommendationOptions,")
        append("numberOfInvocations=$numberOfInvocations,")
        append("tags=$tags,")
        append("utilizationMetrics=$utilizationMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentMemorySize)
        result = 31 * result + (currentPerformanceRisk?.hashCode() ?: 0)
        result = 31 * result + (effectiveRecommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (findingReasonCodes?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionVersion?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookbackPeriodInDays.hashCode())
        result = 31 * result + (memorySizeRecommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (numberOfInvocations.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionRecommendation

        if (accountId != other.accountId) return false
        if (currentMemorySize != other.currentMemorySize) return false
        if (currentPerformanceRisk != other.currentPerformanceRisk) return false
        if (effectiveRecommendationPreferences != other.effectiveRecommendationPreferences) return false
        if (finding != other.finding) return false
        if (findingReasonCodes != other.findingReasonCodes) return false
        if (functionArn != other.functionArn) return false
        if (functionVersion != other.functionVersion) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (!(lookbackPeriodInDays?.equals(other.lookbackPeriodInDays) ?: (other.lookbackPeriodInDays == null))) return false
        if (memorySizeRecommendationOptions != other.memorySizeRecommendationOptions) return false
        if (numberOfInvocations != other.numberOfInvocations) return false
        if (tags != other.tags) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the function.
         */
        public var accountId: kotlin.String? = null
        /**
         * The amount of memory, in MB, that's allocated to the current function.
         */
        public var currentMemorySize: kotlin.Int = 0
        /**
         * The risk of the current Lambda function not meeting the performance needs of its workloads. The higher the risk, the more likely the current Lambda function requires more memory.
         */
        public var currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = null
        /**
         * Describes the effective recommendation preferences for Lambda functions.
         */
        public var effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.LambdaEffectiveRecommendationPreferences? = null
        /**
         * The finding classification of the function.
         *
         * Findings for functions include:
         * + **`Optimized`** — The function is correctly provisioned to run your workload based on its current configuration and its utilization history. This finding classification does not include finding reason codes.
         * + **`NotOptimized`** — The function is performing at a higher level (over-provisioned) or at a lower level (under-provisioned) than required for your workload because its current configuration is not optimal. Over-provisioned resources might lead to unnecessary infrastructure cost, and under-provisioned resources might lead to poor application performance. This finding classification can include the `MemoryUnderprovisioned` and `MemoryUnderprovisioned` finding reason codes.
         * + **`Unavailable`** — Compute Optimizer was unable to generate a recommendation for the function. This could be because the function has not accumulated sufficient metric data, or the function does not qualify for a recommendation. This finding classification can include the `InsufficientData` and `Inconclusive` finding reason codes.Functions with a finding of unavailable are not returned unless you specify the `filter` parameter with a value of `Unavailable` in your `GetLambdaFunctionRecommendations` request.
         */
        public var finding: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendationFinding? = null
        /**
         * The reason for the finding classification of the function.
         *
         * Functions that have a finding classification of `Optimized` don't have a finding reason code.
         *
         * Finding reason codes for functions include:
         * + **`MemoryOverprovisioned`** — The function is over-provisioned when its memory configuration can be sized down while still meeting the performance requirements of your workload. An over-provisioned function might lead to unnecessary infrastructure cost. This finding reason code is part of the `NotOptimized` finding classification.
         * + **`MemoryUnderprovisioned`** — The function is under-provisioned when its memory configuration doesn't meet the performance requirements of the workload. An under-provisioned function might lead to poor application performance. This finding reason code is part of the `NotOptimized` finding classification.
         * + **`InsufficientData`** — The function does not have sufficient metric data for Compute Optimizer to generate a recommendation. For more information, see the [Supported resources and requirements](https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html) in the *Compute Optimizer User Guide*. This finding reason code is part of the `Unavailable` finding classification.
         * + **`Inconclusive`** — The function does not qualify for a recommendation because Compute Optimizer cannot generate a recommendation with a high degree of confidence. This finding reason code is part of the `Unavailable` finding classification.
         */
        public var findingReasonCodes: List<LambdaFunctionRecommendationFindingReasonCode>? = null
        /**
         * The Amazon Resource Name (ARN) of the current function.
         */
        public var functionArn: kotlin.String? = null
        /**
         * The version number of the current function.
         */
        public var functionVersion: kotlin.String? = null
        /**
         * The timestamp of when the function recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days for which utilization metrics were analyzed for the function.
         */
        public var lookbackPeriodInDays: kotlin.Double = 0.0
        /**
         * An array of objects that describe the memory configuration recommendation options for the function.
         */
        public var memorySizeRecommendationOptions: List<LambdaFunctionMemoryRecommendationOption>? = null
        /**
         * The number of times your function code was applied during the look-back period.
         */
        public var numberOfInvocations: kotlin.Long = 0L
        /**
         * A list of tags assigned to your Lambda function recommendations.
         */
        public var tags: List<Tag>? = null
        /**
         * An array of objects that describe the utilization metrics of the function.
         */
        public var utilizationMetrics: List<LambdaFunctionUtilizationMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation) : this() {
            this.accountId = x.accountId
            this.currentMemorySize = x.currentMemorySize
            this.currentPerformanceRisk = x.currentPerformanceRisk
            this.effectiveRecommendationPreferences = x.effectiveRecommendationPreferences
            this.finding = x.finding
            this.findingReasonCodes = x.findingReasonCodes
            this.functionArn = x.functionArn
            this.functionVersion = x.functionVersion
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookbackPeriodInDays = x.lookbackPeriodInDays
            this.memorySizeRecommendationOptions = x.memorySizeRecommendationOptions
            this.numberOfInvocations = x.numberOfInvocations
            this.tags = x.tags
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionRecommendation = LambdaFunctionRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.LambdaEffectiveRecommendationPreferences] inside the given [block]
         */
        public fun effectiveRecommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.LambdaEffectiveRecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.effectiveRecommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.LambdaEffectiveRecommendationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
