// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a filter that returns a more specific list of Amazon ECS service recommendations. Use this filter with the GetECSServiceRecommendations action.
 */
public class EcsServiceRecommendationFilter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     *
     *  Specify `Finding` to return recommendations with a specific finding classification.
     *
     *  Specify `FindingReasonCode` to return recommendations with a specific finding reason code.
     *
     * You can filter your Amazon ECS service recommendations by `tag:key` and `tag-key` tags.
     *
     * A `tag:key` is a key and value combination of a tag assigned to your Amazon ECS service recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Amazon ECS service recommendations that have a tag with the key of `Owner` and the value of `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     *
     * A `tag-key` is the key of a tag assigned to your Amazon ECS service recommendations. Use this filter to find all of your Amazon ECS service recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Amazon ECS service recommendations with a tag key value of `Owner` or without any tag keys assigned.
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFilterName? = builder.name
    /**
     * The value of the filter.
     *
     * The valid values for this parameter are as follows:
     * + If you specify the `name` parameter as `Finding`, specify `Optimized`, `Underprovisioned`, or `Overprovisioned`.
     * + If you specify the `name` parameter as `FindingReasonCode`, specify `CPUUnderprovisioned`, `CPUOverprovisioned`, `MemoryUnderprovisioned`, or `MemoryOverprovisioned`.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsServiceRecommendationFilter(")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsServiceRecommendationFilter

        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the filter.
         *
         *  Specify `Finding` to return recommendations with a specific finding classification.
         *
         *  Specify `FindingReasonCode` to return recommendations with a specific finding reason code.
         *
         * You can filter your Amazon ECS service recommendations by `tag:key` and `tag-key` tags.
         *
         * A `tag:key` is a key and value combination of a tag assigned to your Amazon ECS service recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Amazon ECS service recommendations that have a tag with the key of `Owner` and the value of `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         *
         * A `tag-key` is the key of a tag assigned to your Amazon ECS service recommendations. Use this filter to find all of your Amazon ECS service recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Amazon ECS service recommendations with a tag key value of `Owner` or without any tag keys assigned.
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFilterName? = null
        /**
         * The value of the filter.
         *
         * The valid values for this parameter are as follows:
         * + If you specify the `name` parameter as `Finding`, specify `Optimized`, `Underprovisioned`, or `Overprovisioned`.
         * + If you specify the `name` parameter as `FindingReasonCode`, specify `CPUUnderprovisioned`, `CPUOverprovisioned`, `MemoryUnderprovisioned`, or `MemoryOverprovisioned`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFilter) : this() {
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceRecommendationFilter = EcsServiceRecommendationFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
