// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the projected metrics of an Amazon ECS service recommendation option.
 *
 * To determine the performance difference between your current Amazon ECS service and the recommended option, compare the metric data of your service against its projected metric data.
 */
public class EcsServiceProjectedMetric private constructor(builder: Builder) {
    /**
     * The lower bound values for the projected metric.
     */
    public val lowerBoundValues: List<Double>? = builder.lowerBoundValues
    /**
     * The name of the projected metric.
     *
     * The following metrics are available:
     * + `Cpu` — The percentage of allocated compute units that are currently in use on the service tasks.
     * + `Memory` — The percentage of memory that's currently in use on the service tasks.
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceMetricName? = builder.name
    /**
     * The timestamps of the projected metric.
     */
    public val timestamps: List<Instant>? = builder.timestamps
    /**
     * The upper bound values for the projected metric.
     */
    public val upperBoundValues: List<Double>? = builder.upperBoundValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsServiceProjectedMetric(")
        append("lowerBoundValues=$lowerBoundValues,")
        append("name=$name,")
        append("timestamps=$timestamps,")
        append("upperBoundValues=$upperBoundValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lowerBoundValues?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (timestamps?.hashCode() ?: 0)
        result = 31 * result + (upperBoundValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsServiceProjectedMetric

        if (lowerBoundValues != other.lowerBoundValues) return false
        if (name != other.name) return false
        if (timestamps != other.timestamps) return false
        if (upperBoundValues != other.upperBoundValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedMetric = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The lower bound values for the projected metric.
         */
        public var lowerBoundValues: List<Double>? = null
        /**
         * The name of the projected metric.
         *
         * The following metrics are available:
         * + `Cpu` — The percentage of allocated compute units that are currently in use on the service tasks.
         * + `Memory` — The percentage of memory that's currently in use on the service tasks.
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceMetricName? = null
        /**
         * The timestamps of the projected metric.
         */
        public var timestamps: List<Instant>? = null
        /**
         * The upper bound values for the projected metric.
         */
        public var upperBoundValues: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedMetric) : this() {
            this.lowerBoundValues = x.lowerBoundValues
            this.name = x.name
            this.timestamps = x.timestamps
            this.upperBoundValues = x.upperBoundValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedMetric = EcsServiceProjectedMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
